package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmReplaceSkuAndAddressPO;
import com.tydic.bcm.personal.po.BcmReplaceSkuPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：代下单商品
 * 
 * @author Lihulin
 * @date 2023-11-15 15:13
 **/
@Mapper
@Repository
public interface BcmReplaceSkuMapper {

	/**
	 * 插入单条数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return int 影响数量
	 */
	int insert(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") BcmReplaceSkuPO set, @Param("where") BcmReplaceSkuPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return BcmReplaceSkuPO 结果对象
	 */
	BcmReplaceSkuPO getModelBy(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return List<BcmReplaceSkuPO> 结果对象
	 */
	List<BcmReplaceSkuPO> getList(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @param page 分页参数
	 * @return List<BcmReplaceSkuPO> 结果对象
	 */
	List<BcmReplaceSkuPO> getListPage(BcmReplaceSkuPO bcmReplaceSkuPo, Page<BcmReplaceSkuPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<BcmReplaceSkuPO> list);


	/**
	 * 根据条件查询列表数据，左连接bcm_replace_address_sku
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return List<BcmReplaceSkuAndAddressPO> 结果对象
	 */
	List<BcmReplaceSkuAndAddressPO> getListInnerJoinAddress(BcmReplaceSkuPO bcmReplaceSkuPo);

	/**
	 * 根据条件查询列表数据，左连接bcm_replace_address_sku
	 *
	 * @param bcmReplaceSkuPo 参数对象
	 * @return List<BcmReplaceSkuAndAddressPO> 结果对象
	 */
	List<BcmReplaceSkuAndAddressPO> getListInnerJoinAddressByPage(BcmReplaceSkuPO bcmReplaceSkuPo,Page<BcmReplaceSkuPO> page);
}
