package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.TChnipmpContractInfoExtendPO;
import com.tydic.bcm.personal.po.TChnipmpContractInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * (IPMP)合同;(t_chnipmp_contract_info)表数据库访问层
 *
 * @author : civism
 * @date : 2023-8-18
 */
@Mapper
public interface TChnipmpContractInfoMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param dataId 主键
     * @return 实例对象
     */
    TChnipmpContractInfoPO queryById(Long dataId);

    /**
     * 分页查询指定行数据
     *
     * @param tChnipmpContractInfo 查询条件
     * @param page                 分页对象
     * @return 对象列表
     */
    List<TChnipmpContractInfoPO> queryAllByLimit(TChnipmpContractInfoExtendPO tChnipmpContractInfo, Page<TChnipmpContractInfoPO> page);

    /**
     * 查询最近
     *
     * @param outIdList
     * @param lastSyncDate
     * @return
     */
    List<TChnipmpContractInfoPO> queryLastByOutId(List<String> outIdList, Date lastSyncDate);

    /**
     * 统计总行数
     *
     * @param tChnipmpContractInfo 查询条件
     * @return 总行数
     */
    long count(TChnipmpContractInfoPO tChnipmpContractInfo);

    /**
     * 新增数据
     *
     * @param tChnipmpContractInfo 实例对象
     * @return 影响行数
     */
    int insert(TChnipmpContractInfoPO tChnipmpContractInfo);

    /**
     * 批量新增数据
     *
     * @param entities List<TChnipmpContractInfo> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<TChnipmpContractInfoPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<TChnipmpContractInfo> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<TChnipmpContractInfoPO> entities);

    /**
     * 更新数据
     *
     * @param tChnipmpContractInfo 实例对象
     * @return 影响行数
     */
    int update(TChnipmpContractInfoPO tChnipmpContractInfo);

    /**
     * 通过主键删除数据
     *
     * @param dataId 主键
     * @return 影响行数
     */
    int deleteById(Long dataId);

    /**
     * 查询最近
     *
     * @param originNos
     * @param lastSyncDate
     * @return
     */
    List<TChnipmpContractInfoPO> queryLastByOriginNo(List<String> originNos, Date lastSyncDate);
}