package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.TEspSupplierBankPO;
import com.tydic.bcm.personal.po.TEspSupplierBankQueryPO;
import com.tydic.bcm.personal.po.TEspSupplierBankUpdatePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 类名： TEspSupplierBankMapper
 * 说明：(IPMP)供应商银行账号Mapper
 *
 * @author： lishiqing
 * 时间： 2023/9/11 15:11
 */
@Mapper
public interface TEspSupplierBankMapper {
    /**
     * 根据条件供应商银行账号分页查询列表数据
     * @param po 参数对象
     * @param page 分页参数
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<TEspSupplierBankPO> getPageList(TEspSupplierBankQueryPO po, Page<TEspSupplierBankPO> page);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") TEspSupplierBankUpdatePO set, @Param("where") TEspSupplierBankUpdatePO where);

    /**
     * 根据条件供应商银行账号表查询列表数据
     * @param po 参数对象
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<TEspSupplierBankPO> getList(TEspSupplierBankQueryPO po);
}
