package com.tydic.bcm.personal.flow.impl;


import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.flow.api.BcmCancelFlowService;
import com.tydic.bcm.personal.flow.bo.BcmCancelFlowReqBO;
import com.tydic.bcm.personal.flow.bo.BcmCancelFlowRspBO;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * 标题 BcmCancelFlowServiceImpl
 * 说明 撤销流程
 * 时间 2023/8/29 10:42
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmCancelFlowServiceImpl implements BcmCancelFlowService {

    @Autowired
    private BcmFlowInstanceMapper bcmFlowInstanceMapper;

    @Autowired
    private BcmFlowTaskMapper bcmFlowTaskMapper;


    /**
     * 撤销流程
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmCancelFlowRspBO cancelFlow(BcmCancelFlowReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //更新流程实例
        updateFlowInstance(reqBO);
        //更新流程任务
        updateFlowTask(reqBO);
        return BcmRuUtil.success(BcmCancelFlowRspBO.class);
    }

    /**
     * 更新流程实例
     */
    private void updateFlowInstance(BcmCancelFlowReqBO reqBO) {
        BcmFlowInstancePO bcmFlowInstancePO = new BcmFlowInstancePO();
        bcmFlowInstancePO.setFlowInstId(reqBO.getFlowInstId());
        bcmFlowInstancePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
        bcmFlowInstanceMapper.update(bcmFlowInstancePO);
    }

    /**
     * 更新流程任务
     *
     * @param reqBO
     */
    private void updateFlowTask(BcmCancelFlowReqBO reqBO) {
        BcmFlowTaskPO bcmFlowTaskPO = new BcmFlowTaskPO();
        bcmFlowTaskPO.setFlowInstId(reqBO.getFlowInstId());
        bcmFlowTaskPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
        bcmFlowTaskMapper.update(bcmFlowTaskPO);
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmCancelFlowReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (StrUtil.isBlank(reqBO.getFlowInstId())) {
            throw new ZTBusinessException("入参流程实例id不能为null");
        }
    }
}
