package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题 BcmBasicProjectInfoPO
 * 说明 项目基本信息PO
 * 时间 2023/7/21 11:05
 *
 * @author 唐富强
 */
@Data
public class BcmBasicProjectInfoPO implements Serializable {


    private static final long serialVersionUID = 7311746076336442864L;
    private Long id;

    /**
     * 项目名称
     */
    private String projectName;


    /**
     * 项目编号
     */
    private String projectCode;

    /**
     * 项目Id
     */
    private String projectId;

    /**
     * 预算金额
     */
    private BigDecimal budgetMoney;

    /**
     * 采购组织编码
     */
    private String proOrgCode;

    /**
     * 采购组织名称
     */
    private String proOrgName;

    /**
     * 采购组织id
     */
    private String proOrgId;

    /**
     * 一级机构
     */
    private String oneInstitution;

    /**
     * 一级机构名称
     */
    private String oneOrgName;

    /**
     * 二级机构
     */
    private String twoInstitution;

    /**
     * 二级机构名称
     */
    private String twoOrgName;

    /**
     * 三级机构
     */
    private String threeInstitution;

    /**
     * 三级机构名称
     */
    private String threeOrgName;

    /**
     * 四级机构
     */
    private String fourInstitution;

    /**
     * 四级机构名称
     */
    private String fourOrgName;

    /**
     * 采购经理
     */
    private String execuUserId;

    /**
     * 采购经理名称
     */
    private String execuUserName;

    /**
     * 参审供应商
     */
    private String joinCompanyNm;

    /**
     * 合同类型
     */
    private String contractType;

    /**
     * 采购类型;采购类型：1.固定金额采购2.框架协议采购
     */
    private String requirePurchaseType;

    /**
     * 请购单接收日期
     */
    private String requireFirstApproveTime;

    /**
     * 采购结果移交日期
     */
    private String transResultTime;

    /**
     * 采购方式;采购方式：1.公开招标2.邀请招标3.竞争性谈判4.竞争性磋商5.询价6.单一来源采购7.其他
     */
    private String purchaseType;

    /**
     * 代理机构名称
     */
    private String agentNm;

    /**
     * 是否公开征集
     */
    private String isPublishNews;

    /**
     * 时长
     */
    private String transTotalDayCount;

    /**
     * 成交供应商
     */
    private String joinCompanyDealNm;

    /**
     * 计划完成日期
     */
    private String planCompleteDate;

    /**
     * 请购部门
     */
    private String requireDeptNm;

    /**
     * 归口部门id
     */
    private String putUnderDeptId;

    /**
     * 归口部门名称
     */
    private String putUnderDeptNm;

    /**
     * 采购主体;采购主体：1.自行采购2.委托采购
     */
    private String organizeType;

    /**
     * 项目类型
     */
    private String projectType;

    /**
     * 成交金额
     */
    private String finalBudget;

    /**
     * 已付款金额
     */
    private String payBudgetAmt;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建人id
     */
    private Long createUserId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新人id
     */
    private Long updateUserId;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 状态 0-停用 1-启用
     */
    private Integer status;

    /**
     * 删除标识 0-未删除 1-删除
     */
    private Integer delFlag;

}
