package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题 BcmFmisFinmattersPO
 * 说明 NC基础数据临时表：财务事项申请单PO
 * 时间 2023/8/17 11:05
 *
 * @author 唐富强
 */
@Data
public class BcmFmisFinmattersPO implements Serializable {


    private static final long serialVersionUID = 6147938115144667292L;
    /**
     * ID
     */
    private Long id;

    /**
     * 事项申请单编码
     */
    private String fileId;

    /**
     * 事项申请单名称
     */
    private String itemName;

    /**
     * 预算项目编码
     */
    private String objCode;

    /**
     * 预算项目名称
     */
    private String objName;

    /**
     * 机构编码
     */
    private String code;

    /**
     * 机构名称
     */
    private String name;

    /**
     * 事项申请单状态:1-待审批；2-维护中；3-在用；4-停用
     */
    private String projectStatus;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 创建人
     */
    private String creator;

    /**
     * 最好修改时间
     */
    private String modifiedTime;

    /**
     * 最后修改人
     */
    private String modifier;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;

}