package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;


/**
 * 标题 BcmGuwpOrgInfoPO
 * 说明 机构信息表PO
 * 时间 2023/8/16 14:12
 *
 * @author 唐富强
 */
@Data
public class BcmGuwpOrgInfoPO implements Serializable {
    private static final long serialVersionUID = 4819779279546684045L;
    /**
     * id
     */
    private Long id;

    /**
     * 组织机构ID
     */
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    /**
     * 组织机构编码
     */
    private String orgCode;

    /**
     * 上级机构代码
     */
    private String parentOrgCode;

    /**
     * 父机构编号
     */
    private Long parentOrgId;

    /**
     * 机构简称
     */
    private String shortName;

    /**
     * 是否境外
     */
    private String inCountry;

    /**
     * 统一社会信用代码
     */
    private String uscd;

    /**
     * 联系人
     */
    private String cntctsName;

    /**
     * 手机号码
     */
    private String mobNo;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 电话
     */
    private String cntctPhnNo;

    /**
     * 传真
     */
    private String faxNo;

    /**
     * 营业执照URL
     */
    private String bsnLicUrl;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String memo;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private Long createUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private Long modifyUser;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果
     */
    private String dealResult;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BcmGuwpOrgInfoPO that = (BcmGuwpOrgInfoPO) o;
        return Objects.equals(orgId, that.orgId) && Objects.equals(orgName, that.orgName) && Objects.equals(orgCode, that.orgCode) && Objects.equals(parentOrgCode, that.parentOrgCode) && Objects.equals(parentOrgId, that.parentOrgId) && Objects.equals(shortName, that.shortName) && Objects.equals(inCountry, that.inCountry) && Objects.equals(uscd, that.uscd) && Objects.equals(cntctsName, that.cntctsName) && Objects.equals(mobNo, that.mobNo) && Objects.equals(email, that.email) && Objects.equals(cntctPhnNo, that.cntctPhnNo) && Objects.equals(faxNo, that.faxNo) && Objects.equals(bsnLicUrl, that.bsnLicUrl) && Objects.equals(status, that.status) && Objects.equals(memo, that.memo) && Objects.equals(createTime, that.createTime) && Objects.equals(createUser, that.createUser) && Objects.equals(updateTime, that.updateTime) && Objects.equals(modifyUser, that.modifyUser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgId, orgName, orgCode, parentOrgCode, parentOrgId, shortName, inCountry, uscd, cntctsName, mobNo, email, cntctPhnNo, faxNo, bsnLicUrl, status, memo, createTime, createUser, updateTime, modifyUser);
    }
}