package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 类名： BcmIpmpSupplierBankPO
 * 说明：供应商银行账号--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/9/11 15:08
 */
@Data
public class BcmIpmpSupplierBankPO implements Serializable {
    private static final long serialVersionUID = -3661253823707712274L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 外部银行账号ID
     */
    private String bankId;

    /**
     * 供应商ID
     */
    private String supplierId;

    /**
     * 开户行持卡人名字
     */
    private String userName;

    /**
     * 银行卡号
     */
    private String bankCard;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 总行ID
     */
    private String bankTypeId;

    /**
     * 支行名称
     */
    private String bankBranch;

    /**
     * 支行ID
     */
    private String bankDocId;

    /**
     * 币种
     */
    private String signCurrency;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 1：已删除 2：未删除
     */
    private String isDelete;

    /**
     * 账号状态，00-未启用，01-已启用
     */
    private String bankStatus;

    /**
     * 外部银行账号ID
     */
    private List<String> bankIds;
}
