package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名： BcmPurchasePurposeConfigPO
 * 说明：采购用途配置--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/7/21 10:33
 */
@Data
public class BcmPurchasePurposeConfigPO implements Serializable {
    private static final long serialVersionUID = -6805706120947203474L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 采购用途ID
     */
    private Long purchasePurposeId;

    /**
     * 采购用途名称
     */
    private String purchasePurposeName;

    /**
     * 采购用途名称(精确查询字段)
     */
    private String purchasePurposeNameAcc;

    /**
     * 创建人ID
     */
    private Long createUserId;

    /**
     * 创建人名称
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新人ID
     */
    private Long updateUserId;

    /**
     * 更新人名称
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 删除标识
     */
    private Integer delFlag;


    /**
     * 关联标签编码
     */
    private String relaLabelCode;

    /**
     * 关联标签名称
     */
    private String relaLabelName;

    /**
     * 是否公用：0：是；1：否
     */
    private Integer isCommon;
}
