package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 标题 BcmTChnipmpProjectPO
 * 说明 (IPMP)项目表;智采平台基础数据临时表：项目表PO
 * 时间 2023/8/17 15:19
 *
 * @author 唐富强
 */
@Data
public class BcmTChnipmpProjectPO implements Serializable {


    private static final long serialVersionUID = -5857840539652051333L;
    /**
     * ID
     */
    private Long id;

    /**
     * 项目id
     */
    private String projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目編号
     */
    private String projectNo;

    /**
     * 一级机构
     */
    private String oneInstitution;

    /**
     * 一级机构名称
     */
    private String oneOrgName;

    /**
     * 二级机构
     */
    private String twoInstitution;

    /**
     * 二级机构名称
     */
    private String twoOrgName;

    /**
     * 三级机构
     */
    private String threeInstitution;

    /**
     * 三级机构名称
     */
    private String threeOrgName;

    /**
     * 四级机构
     */
    private String fourInstitution;

    /**
     * 四级机构名称
     */
    private String fourOrgName;

    /**
     * 项目预算
     */
    private String projectBudget;

    /**
     * 项目状志
     */
    private String currentStatus;

    /**
     * 项目创建日期
     */
    private Date createDate;

    /**
     * 修改日期
     */
    private Date updateTime;

    /**
     * 采购经理
     */
    private String execuUserId;

    /**
     * 采购经理名称
     */
    private String execuUserName;

    /**
     * 参审供应商
     */
    private String joinCompanyNm;

    /**
     * 合同类型
     */
    private String contractType;

    /**
     * 采购类型;采购类型：1.固定金额采购2.框架协议采购
     */
    private String requirePurchaseType;

    /**
     * 请购单接收日期
     */
    private String requireFirstApproveTime;

    /**
     * 采购结果移交日期
     */
    private String transResultTime;

    /**
     * 采购方式;采购方式：1.公开招标2.邀请招标3.竞争性谈判4.竞争性磋商5.询价6.单一来源采购7.其他
     */
    private String purchaseType;

    /**
     * 代理机构名称
     */
    private String agentNm;

    /**
     * 是否公开征集
     */
    private String isPublishNews;

    /**
     * 时长
     */
    private String transTotalDayCount;

    /**
     * 成交供应商
     */
    private String joinCompanyDealNm;

    /**
     * 计划完成日期
     */
    private String planCompleteDate;

    /**
     * 请购部门
     */
    private String requireDeptNm;

    /**
     * 归口部门id
     */
    private String putUnderDeptId;

    /**
     * 归口部门名称
     */
    private String putUnderDeptNm;

    /**
     * 采购主体;采购主体：1.自行采购2.委托采购
     */
    private String organizeType;

    /**
     * 项目类型
     */
    private String projectType;

    /**
     * 成交金额
     */
    private String finalBudget;

    /**
     * 已付款金额
     */
    private String payBudgetAmt;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果;处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;

}