package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：商城内部调用日志记录表
 *
 * @author Lihulin
 * @date 2024-01-08 15:39
 **/
@Data
public class InSystemCallLogPO implements Serializable {
    private static final long serialVersionUID = -6860484781711742661L;

    /**
     * id
     */
    private Long id;
    /**
     * 调用方接口名称
     */
    private String interfaceName;
    /**
     * 调用类型：1 nc预占回调
     */
    private String type;
    /**
     * 调用方入参
     */
    private String inputMessage;
    /**
     * 调用方出参
     */
    private String outputMessage;
    /**
     * 落地接口url
     */
    private String url;
    /**
     * 落地入参
     */
    private String inputResponMessage;
    /**
     * 落地出参
     */
    private String outputResponMessage;
    /**
     * 传出响应时间
     */
    private Date outputResponTime;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 调用结果:
     * 0：成功：
     * 1：失败
     */
    private Integer callResult;
    /**
     * 失败原因
     */
    private String failReason;
    /**
     * 失败次数
     */
    private Integer failTurn;
    private String colum1;
    private String colum2;
    private String colum3;
    /**
     * 排序
     */
    private String orderBy;

}
