package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * (IPMP)供应商表;智采平台基础数据临时表：供应商
 *
 * @author : civism
 * @date : 2023-8-17
 */
@Data
public class TChnipmpSupplierPO implements Serializable {
    private static final long serialVersionUID = -4368614579638397326L;
    /**
     * ID
     */
    private Long id;
    /**
     * 供应商id
     */
    private String companyId;
    /**
     * 供应商社会信用代码
     */
    private String companyNo;
    /**
     * 信用代码类型;信用代码类型：2社会统一信用代码 3:系统生成
     */
    private String companyNoType;
    /**
     * 供应商名称
     */
    private String companyName;
    /**
     * 供商行业
     */
    private String companyProductNames;
    /**
     * 主联系人
     */
    private String linkman;
    /**
     * 主联系人固话
     */
    private String linkTel;
    /**
     * 主联系人手机
     */
    private String linkMobile;
    /**
     * 主联系人ID
     */
    private String linkId;
    /**
     * 主联系人邮箱
     */
    private String linkEmail;
    /**
     * 营业执照id
     */
    private String qlfEcmId;
    /**
     * 营业执照名
     */
    private String qlfEcmName;
    /**
     * 机构状志;机构状志 00正
     * 常使用；01禁止使用，02已删除，03待审核；04宙核不通过；05黑
     * 名単; 07 部分禁用
     */
    private String status;
    /**
     * 创建时间
     */
    private Date recCrtTs;
    /**
     * 更新时间
     */
    private Date recUpdTs;
    /**
     * 推送时间
     */
    private Date pushTime;
    /**
     * 处理时间
     */
    private Date dealTime;
    /**
     * 处理结果;处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TChnipmpSupplierPO that = (TChnipmpSupplierPO) o;
        return Objects.equals(companyId, that.companyId) && Objects.equals(companyNo, that.companyNo) && Objects.equals(companyNoType, that.companyNoType) && Objects.equals(companyName, that.companyName) && Objects.equals(companyProductNames, that.companyProductNames) && Objects.equals(linkman, that.linkman) && Objects.equals(linkTel, that.linkTel) && Objects.equals(linkMobile, that.linkMobile) && Objects.equals(linkId, that.linkId) && Objects.equals(linkEmail, that.linkEmail) && Objects.equals(qlfEcmId, that.qlfEcmId) && Objects.equals(qlfEcmName, that.qlfEcmName) && Objects.equals(status, that.status) && Objects.equals(recCrtTs, that.recCrtTs) && Objects.equals(recUpdTs, that.recUpdTs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, companyNo, companyNoType, companyName, companyProductNames, linkman, linkTel, linkMobile, linkId, linkEmail, qlfEcmId, qlfEcmName, status, recCrtTs, recUpdTs);
    }
}