package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.*;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.task.api.BcmPaymentProjectSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncPaymentProjectReqBO;
import com.tydic.bcm.personal.task.bo.BcmFmisSyncPaymentProjectRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 类名： BcmPaymentProjectSyncTaskServiceImpl
 * 说明：收支项目同步比对任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/15 12:49
 */
@HTServiceImpl
public class BcmPaymentProjectSyncTaskServiceImpl implements BcmPaymentProjectSyncTaskService {

    @Autowired
    private BcmBdInoutbusiclassFmisMapper bcmBdInoutbusiclassFmisMapper;

    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    private static final Integer delPage = 1;


    @Value("${virtual.finance.org}")
    private String virtualFinanceOrg;


    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;

    private static final Long defaultUserId = 1L;

    private static final String defaultUserName = "系统管理员";

    @Override
    @Async("global-thread-pool")
    public BcmFmisSyncPaymentProjectRspBO syncPaymentProject(BcmFmisSyncPaymentProjectReqBO reqBO) {
        BcmFmisSyncPaymentProjectRspBO rspBO = new BcmFmisSyncPaymentProjectRspBO();
        BcmBdInoutbusiclassFmisPO qryPO = new BcmBdInoutbusiclassFmisPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        Page<BcmBdInoutbusiclassFmisPO> page = new Page<>(delPage, dealCount);
        List<BcmBdInoutbusiclassFmisPO> list = bcmBdInoutbusiclassFmisMapper.getPageList(qryPO, page);
        if (ObjectUtil.isEmpty(list)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }
        // 循环、分页查询TB_BUDGETSUB_FMIS表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
        int syncNum = 0;
        while (true) {
            Page<BcmBdInoutbusiclassFmisPO> pageNow = new Page<>(delPage, dealCount);
            List<BcmBdInoutbusiclassFmisPO> pageList = bcmBdInoutbusiclassFmisMapper.getPageList(qryPO, pageNow);
            if (ObjectUtil.isEmpty(pageList)) {
                rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
                rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
                rspBO.setSyncNum(syncNum);
                return rspBO;
            }
            // 根据TB_BUDGETSUB_FMIS的PK_OBJ去查询bcm_budget_project_info的PROJECT_ID（批量查询）
            List<String> projectIdList = pageList.stream().map(BcmBdInoutbusiclassFmisPO::getPkInoutbusiclass).collect(Collectors.toList());
            List<String> orgCodeList = pageList.stream().map(BcmBdInoutbusiclassFmisPO::getPkOrg).collect(Collectors.toList());
            BcmQueryPaymentProjectInfoPO qryProjectPO = new BcmQueryPaymentProjectInfoPO();
            qryProjectPO.setProjectIdList(projectIdList);
            qryProjectPO.setOrgIdList(orgCodeList);
            qryProjectPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            List<BcmPaymentProjectInfoPO> projectInfoPOS = bcmPaymentProjectInfoMapper.getList(qryProjectPO);
            // 新增的集合
            List<BcmPaymentProjectInfoPO> batchInsertPOList = new ArrayList<>();
            // 判断收支项目是否为空,如果不为空则存在更新数据，
            if (ObjectUtil.isNotEmpty(projectInfoPOS)) {
                // 拿到更新的集合
                Map<String, BcmPaymentProjectInfoPO> updateMap = projectInfoPOS.stream().collect(Collectors.toMap(info -> info.getProjectId() + "-" + info.getFinancialOrgId(), Function.identity()));
                // 做更新操作
                for (BcmBdInoutbusiclassFmisPO item : pageList) {
                    // 查询机构信息
                    BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty(nowOrgPO) && !virtualFinanceOrg.equals(item.getPkOrg())) {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    if (!updateMap.containsKey((item.getPkInoutbusiclass() + "-" + item.getPkOrg()))) { //新增
                        // 入参组装
                        BcmPaymentProjectInfoPO insertPO = setInsertPO(item, nowOrgPO);
                        batchInsertPOList.add(insertPO);
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.SUCCESS);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                        continue;
                    }
                    BcmPaymentProjectInfoPO sourcePO = updateMap.get(item.getPkInoutbusiclass() + "-" + item.getPkOrg());
                    BcmPaymentProjectInfoPO setPO = new BcmPaymentProjectInfoPO();
                    setPO.setProjectName(item.getName());
                    setPO.setProjectCode(item.getCode());
                    setPO.setStatus(item.getEnablestate());
                    setPO.setFinancialOrgId(item.getPkOrg());
                    //填充虚拟的财务组织
                    virtualFinanceOrg(setPO, nowOrgPO);
                    // 如果有值变更,
                    if (!setPO.equals(sourcePO)) {
                        setPO.setUpdateUserId(defaultUserId);
                        setPO.setUpdateUserName(defaultUserName);
                        setPO.setUpdateTime(new Date());
                        if (virtualFinanceOrg.equals(item.getPkOrg())) {
                            setPO.setPublicFlag(2);
                        } else {
                            setPO.setPublicFlag(1);
                        }
                        BcmPaymentProjectInfoPO wherePO = new BcmPaymentProjectInfoPO();
                        wherePO.setId(sourcePO.getId());
                        bcmPaymentProjectInfoMapper.updateBy(setPO, wherePO);
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.SUCCESS);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                    } else {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.SKIP);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                    }
                }
            } else {
                for (BcmBdInoutbusiclassFmisPO item : pageList) {
                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.Status.ENABLE);
                    } else {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    // 查询机构信息
                    BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty(nowOrgPO) && !virtualFinanceOrg.equals(item.getPkOrg())) {
                        updateStatus(item, BcmPersonalCommonConstant.DealResult.FAIL);
                        // item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }
                    // 入参组装
                    BcmPaymentProjectInfoPO insertPO = setInsertPO(item, nowOrgPO);
                    batchInsertPOList.add(insertPO);
                    updateStatus(item, BcmPersonalCommonConstant.DealResult.SUCCESS);
                    // item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                }
            }

            // 处理新增数据
            if (ObjectUtil.isNotEmpty(batchInsertPOList)) {
                int insertNum = bcmPaymentProjectInfoMapper.insertBatch(batchInsertPOList);
                syncNum = syncNum + insertNum;
            }

            // 批量更新临时表数据
//            Map<String, List<BcmBdInoutbusiclassFmisPO>> dealResultMap = pageList.stream().collect(Collectors.groupingBy(BcmBdInoutbusiclassFmisPO::getDealResult));
//            for (String dealResult : dealResultMap.keySet()) {
//                List<BcmBdInoutbusiclassFmisPO> dealResultPOList = dealResultMap.get(dealResult);
//                List<Long> dealIds = dealResultPOList.stream().map(BcmBdInoutbusiclassFmisPO::getId).collect(Collectors.toList());
//                BcmBdInoutbusiclassFmisUpdatePO fmisSetPO = new BcmBdInoutbusiclassFmisUpdatePO();
//                fmisSetPO.setDealResult(dealResult);
//                fmisSetPO.setDealTime(new Date());
//                BcmBdInoutbusiclassFmisUpdatePO fmisWherePO = new BcmBdInoutbusiclassFmisUpdatePO();
//                fmisWherePO.setIdList(dealIds);
//                bcmBdInoutbusiclassFmisMapper.updateBy(fmisSetPO, fmisWherePO);
//            }
        }
    }

    /**
     * 修改临时表数据
     *
     * @param item
     * @param dealResult
     */
    private void updateStatus(BcmBdInoutbusiclassFmisPO item, String dealResult) {
        BcmBdInoutbusiclassFmisUpdatePO fmisSetPO = new BcmBdInoutbusiclassFmisUpdatePO();
        fmisSetPO.setDealResult(dealResult);
        fmisSetPO.setDealTime(new Date());
        BcmBdInoutbusiclassFmisUpdatePO fmisWherePO = new BcmBdInoutbusiclassFmisUpdatePO();
        fmisWherePO.setId(item.getId());
        bcmBdInoutbusiclassFmisMapper.updateBy(fmisSetPO, fmisWherePO);
    }

    /**
     * 设置新增PO
     *
     * @param item
     * @param nowOrgPO
     * @return
     */
    private BcmPaymentProjectInfoPO setInsertPO(BcmBdInoutbusiclassFmisPO item, BcmOrgOrgsFmisPO nowOrgPO) {
        BcmPaymentProjectInfoPO insertPO = new BcmPaymentProjectInfoPO();
        insertPO.setId(BcmIdUtil.nextId());
        insertPO.setProjectId(item.getPkInoutbusiclass());
        insertPO.setProjectCode(item.getCode());
        insertPO.setProjectName(item.getName());
        insertPO.setStatus(item.getEnablestate());
        //填充虚拟的财务组织
        virtualFinanceOrg(insertPO, nowOrgPO);
        insertPO.setCreateUserId(defaultUserId);
        insertPO.setCreateUserName(defaultUserName);
        insertPO.setCreateTime(new Date());
        insertPO.setUpdateUserId(defaultUserId);
        insertPO.setUpdateUserName(defaultUserName);
        insertPO.setUpdateTime(new Date());
        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        if (virtualFinanceOrg.equals(item.getPkOrg())) {
            insertPO.setPublicFlag(2);
        } else {
            insertPO.setPublicFlag(1);
        }
        return insertPO;
    }

    private void virtualFinanceOrg(BcmPaymentProjectInfoPO bcmPaymentProjectInfoPO, BcmOrgOrgsFmisPO nowOrgPO) {
        if (nowOrgPO != null) {
            bcmPaymentProjectInfoPO.setFinancialOrgId(nowOrgPO.getPkOrg());
            bcmPaymentProjectInfoPO.setFinancialOrgCode(nowOrgPO.getCode());
            bcmPaymentProjectInfoPO.setFinancialOrgName(nowOrgPO.getName());
        } else {
            bcmPaymentProjectInfoPO.setFinancialOrgId(virtualFinanceOrg);
            bcmPaymentProjectInfoPO.setFinancialOrgCode(virtualFinanceOrg);
            bcmPaymentProjectInfoPO.setFinancialOrgName("虚拟财务组织");
        }
    }
}
