package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmQryAddressGroupService;
import com.tydic.bcm.personal.address.bo.BcmQryAddressGroupBO;
import com.tydic.bcm.personal.address.bo.BcmQryAddressGroupReqBO;
import com.tydic.bcm.personal.address.bo.BcmQryAddressGroupRspBO;
import com.tydic.bcm.personal.dao.BcmAddressGroupMapper;
import com.tydic.bcm.personal.po.BcmAddressGroupPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

@HTServiceImpl
public class BcmQryAddressGroupServiceImpl implements BcmQryAddressGroupService {

    @Autowired
    private BcmAddressGroupMapper bcmAddressGroupMapper;

    @Override
    public BcmQryAddressGroupRspBO qryAddressGroup(BcmQryAddressGroupReqBO reqBO) {

        // 入参校验
        judge(reqBO);
        BcmQryAddressGroupRspBO rspBO = new BcmQryAddressGroupRspBO();

        BcmAddressGroupPO qryPO = JUtil.js(reqBO, BcmAddressGroupPO.class);
        List<BcmAddressGroupPO> list = bcmAddressGroupMapper.getListJoinRel(qryPO);
        if (!CollectionUtils.isEmpty(list)) {
            rspBO.setRows(JUtil.jsl(list, BcmQryAddressGroupBO.class));
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 入参校验
     *
     * @param reqBO
     * @return
     */
    private void judge(BcmQryAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("地址分组查询入参为空");
        }
    }

}
