package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.address.api.BcmQueryPageReplaceSkuService;
import com.tydic.bcm.personal.address.bo.BcmQueryPageReplaceSkuReqBo;
import com.tydic.bcm.personal.address.bo.BcmQueryPageReplaceSkuRspBo;
import com.tydic.bcm.personal.address.bo.BcmReplaceAddressSkuBO;
import com.tydic.bcm.personal.address.bo.BcmReplaceSkuBO;
import com.tydic.bcm.personal.dao.BcmReplaceAddressSkuMapper;
import com.tydic.bcm.personal.dao.BcmReplaceSkuMapper;
import com.tydic.bcm.personal.po.BcmReplaceAddressSkuPO;
import com.tydic.bcm.personal.po.BcmReplaceSkuPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：BcmQueryPageReplaceSkuServiceImpl
 * 说明：分页查询代下单商品信息实现
 * 时间：2023/11/21 13:59
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class BcmQueryPageReplaceSkuServiceImpl implements BcmQueryPageReplaceSkuService {
    @Autowired
    private BcmReplaceSkuMapper bcmReplaceSkuMapper;
    @Autowired
    private BcmReplaceAddressSkuMapper bcmReplaceAddressSkuMapper;

    @Override
    public BcmQueryPageReplaceSkuRspBo queryPageReplaceSku(BcmQueryPageReplaceSkuReqBo reqBo) {
        BcmQueryPageReplaceSkuRspBo rspBo = new BcmQueryPageReplaceSkuRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        //通过userId查询当前用户勾选商品的商品信息
        BcmReplaceSkuPO qryPo = new BcmReplaceSkuPO();
        Page<BcmReplaceSkuPO> page = new Page<>(reqBo.getPageNo(), reqBo.getPageSize());
        qryPo.setCreateUserId(reqBo.getUserId());
        List<BcmReplaceSkuPO> replaceSkuPoList = bcmReplaceSkuMapper.getListPage(qryPo, page);
        List<BcmReplaceSkuBO> bcmReplaceSkuBOList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(replaceSkuPoList)) {
            for (BcmReplaceSkuPO bcmReplaceSkuPo : replaceSkuPoList) {
                BcmReplaceSkuBO bcmReplaceSkuBO = new BcmReplaceSkuBO();
                BeanUtils.copyProperties(bcmReplaceSkuPo, bcmReplaceSkuBO);
                bcmReplaceSkuBOList.add(bcmReplaceSkuBO);
            }
        }
        //组装地址信息
        if (CollectionUtil.isNotEmpty(bcmReplaceSkuBOList)) {
            List<Long> replaceSkuIds = bcmReplaceSkuBOList.stream().map(BcmReplaceSkuBO::getId).distinct().collect(Collectors.toList());
            BcmReplaceAddressSkuPO qryReplaceAddressSkuPo = new BcmReplaceAddressSkuPO();
            qryReplaceAddressSkuPo.setReplaceSkuIds(replaceSkuIds);
            List<BcmReplaceAddressSkuPO> addressSkuPos = bcmReplaceAddressSkuMapper.getList(qryReplaceAddressSkuPo);
            if (CollectionUtil.isNotEmpty(addressSkuPos)) {
                List<BcmReplaceAddressSkuBO> bcmReplaceAddressSkuBOS = JSONObject.parseArray(JSONObject.toJSONString(addressSkuPos), BcmReplaceAddressSkuBO.class);
                Map<Long, List<BcmReplaceAddressSkuBO>> addressSkuMap =
                        bcmReplaceAddressSkuBOS.stream().collect(Collectors.groupingBy(BcmReplaceAddressSkuBO::getReplaceSkuId));
                for (Map.Entry<Long, List<BcmReplaceAddressSkuBO>> longListEntry : addressSkuMap.entrySet()) {
                    for (BcmReplaceSkuBO bcmReplaceSkuBO : bcmReplaceSkuBOList) {
                        if (bcmReplaceSkuBO.getId().equals(longListEntry.getKey())) {
                            bcmReplaceSkuBO.setAddressSkuList(longListEntry.getValue());
                        }
                    }
                }
            }
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setRows(bcmReplaceSkuBOList);
        return rspBo;
    }
}
