package com.tydic.bcm.personal.commodity.impl;

import com.tydic.bcm.personal.commodity.api.BcmApplyCommodityPlaceOrderResultService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityPlaceOrderResultReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityPlaceOrderResultRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/10/31 10:26
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmApplyCommodityPlaceOrderResultServiceImpl implements BcmApplyCommodityPlaceOrderResultService {

    private final BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Override
    public BcmApplyCommodityPlaceOrderResultRspBO placeOrderResult(BcmApplyCommodityPlaceOrderResultReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        bcmApplyCommodityOrderSupplierReplyItemMapper.updatePlaceOrderResult(reqBO.getApplyOrderId(), reqBO.getSkuIds());
        return new BcmApplyCommodityPlaceOrderResultRspBO();
    }
}
