package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.constants.*;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderListPagePO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryApplyCommodityOrderPageListServiceImpl
 * 说明 上架申请单-列表查询（分页）实现
 * 时间 2023/7/31 14:25
 *
 * @author 唐富强
 */
@HTServiceImpl
@Slf4j
public class BcmQueryApplyCommodityOrderPageListServiceImpl implements BcmQueryApplyCommodityOrderPageListService {

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    /**
     * 列表查询（分页）实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryApplyCommodityOrderPageListRspBO queryApplyCommodityOrderPageList(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = getBcmApplyCommodityOrderPO(reqBO);
        Page<BcmApplyCommodityOrderListPagePO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmApplyCommodityOrderListPagePO> list = bcmApplyCommodityOrderMapper.getListPage(bcmQueryApplyCommodityOrderPO, page);
        return setRspBO(list, page);
    }

    /**
     * 出参组装
     *
     * @param list
     * @param page
     * @return
     */
    private BcmQueryApplyCommodityOrderPageListRspBO setRspBO(List<BcmApplyCommodityOrderListPagePO> list, Page<BcmApplyCommodityOrderListPagePO> page) {
        BcmQueryApplyCommodityOrderPageListRspBO rspBO = BcmRuUtil.success(BcmQueryApplyCommodityOrderPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list, BcmApplyCommodityOrderPageBO.class));
        if (CollectionUtils.isNotEmpty(rspBO.getRows())) {
            //翻译
            for (BcmApplyCommodityOrderPageBO bo : rspBO.getRows()) {
                bo.setCancelTypeStr(BcmPersonalCommodityCancelTypeEnum.getCancelDesc(bo.getCancelType()));
                bo.setIsCustomizedFlagStr(BcmPersonalIsCustomizedFlagEnum.getStatusDesc(bo.getIsCustomizedFlag()));
                bo.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(bo.getApplyOrderStatus()));
                //是否提交挂接结果设置
                if (BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus().equals(bo.getApplyOrderStatus())
                        || BcmPersonalApplyOrderStatusEnum.FINISH.getStatus().equals(bo.getApplyOrderStatus())) {
                    bo.setHitchFlag(BcmPersonalCommonStatusEnum.YES.getStatus());
                    bo.setHitchFlagStr(BcmPersonalCommonStatusEnum.YES.getDesc());
                } else {
                    bo.setHitchFlag(BcmPersonalCommonStatusEnum.NO.getStatus());
                    bo.setHitchFlagStr(BcmPersonalCommonStatusEnum.NO.getDesc());
                }
                if (BcmPersonalApplyOrderStatusEnum.FINISH.getStatus().equals(bo.getApplyOrderStatus())) {
                    //查询是否下单完成
                    BcmQueryApplyCommodityOrderSupplierReplyItemPO replyItemPO = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                    replyItemPO.setApplyOrderId(bo.getApplyOrderId());
                    replyItemPO.setSelectFlag(BooleanFlagEnum.YES.getFlag());
                    replyItemPO.setPlaceOrderFlag(BooleanFlagEnum.YES.getFlag());
                    List<BcmApplyCommodityOrderSupplierReplyItemPO> replySelectPlaceList = bcmApplyCommodityOrderSupplierReplyItemMapper.getList(replyItemPO);
                    if (CollectionUtil.isEmpty(replySelectPlaceList)) {
                        bo.setPlaceOrderFlag(BooleanFlagEnum.NO.getFlag());
                    } else {
                        bo.setPlaceOrderFlag(BooleanFlagEnum.YES.getFlag());
                    }
                }

            }
        }
        log.info("上架申请单列表出参{}", JSONObject.toJSONString(rspBO));
        return rspBO;
    }

    /**
     * 参数组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryApplyCommodityOrderPO getBcmApplyCommodityOrderPO(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = BcmRuUtil.js(reqBO, BcmQueryApplyCommodityOrderPO.class);
        bcmQueryApplyCommodityOrderPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        bcmQueryApplyCommodityOrderPO.setOrderBy("a.CREATE_TIME DESC");
        return bcmQueryApplyCommodityOrderPO;
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getSumFlag() == null) {
            throw new ZTBusinessException("参数是否查询汇总数据不能为null");
        }

    }
}
