package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateReplyItemsService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateReplyItemsReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateReplyItemsRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名：BcmUpdateReplyItemsServiceImpl
 * 说明：描述一下类的作用
 * 时间：2023/12/11
 * 作者：pengyuqi
 */
@HTServiceImpl
@Slf4j
public class BcmUpdateReplyItemsServiceImpl implements BcmUpdateReplyItemsService {
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Override
    public BcmUpdateReplyItemsRspBO updateReplyItems(BcmUpdateReplyItemsReqBO reqBO) {
        log.debug("开始执行定时任务");
        BcmApplyCommodityOrderPO commodityOrderPO =
                bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (null == commodityOrderPO || ObjectUtils.isEmpty(commodityOrderPO.getId())) {
            throw new ZTBusinessException("未查询到相关上架申请单数据");
        }
        //修改申请单选定状态
//        updateOrder(reqBO, commodityOrderPO);
        //查询应答明细
        BcmQueryApplyCommodityOrderSupplierReplyItemPO qryItems = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        qryItems.setApplyOrderId(commodityOrderPO.getApplyOrderId());
        List<BcmApplyCommodityOrderSupplierReplyItemPO> replyItemMapperList =
                bcmApplyCommodityOrderSupplierReplyItemMapper.getList(qryItems);
        if (!CollectionUtils.isEmpty(replyItemMapperList)) {
            //修改应答明细
            updateItem(reqBO, replyItemMapperList);
        }
        BcmUpdateReplyItemsRspBO rspBO = new BcmUpdateReplyItemsRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 修改应答明细
     *
     * @param reqBO
     * @param replyItemMapperList
     */
    private void updateItem(BcmUpdateReplyItemsReqBO reqBO, List<BcmApplyCommodityOrderSupplierReplyItemPO> replyItemMapperList) {
        //找出salePrice最低得明细
        BcmApplyCommodityOrderSupplierReplyItemPO miniPrice =
                replyItemMapperList.stream()
                        .filter(e -> !ObjectUtils.isEmpty(e.getSalePrice()))
                        .min(Comparator.comparing(BcmApplyCommodityOrderSupplierReplyItemPO::getSalePrice))
                        .orElse(null);
        log.info("最低价为{}",miniPrice);
        //将此明细修改为选中
        if (null!=miniPrice) {
            BcmApplyCommodityOrderSupplierReplyItemPO updateItemPo = new BcmApplyCommodityOrderSupplierReplyItemPO();
            updateItemPo.setId(miniPrice.getId());
            updateItemPo.setReplyItemId(updateItemPo.getReplyItemId());
            updateItemPo.setReplyId(updateItemPo.getReplyItemId());
            updateItemPo.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
            updateItemPo.setUpdateTime(new Date());
            updateItemPo.setUpdateUserId(reqBO.getUpdateUserId());
            updateItemPo.setUpdateUserName(reqBO.getUpdateUserName());
            bcmApplyCommodityOrderSupplierReplyItemMapper.update(updateItemPo);
        }
    }

    /**
     * 修改申请单选定状态
     *
     * @param reqBO
     * @param commodityOrderPO
     */
    private void updateOrder(BcmUpdateReplyItemsReqBO reqBO, BcmApplyCommodityOrderPO commodityOrderPO) {
        BcmApplyCommodityOrderPO updatePo = new BcmApplyCommodityOrderPO();
        updatePo.setId(commodityOrderPO.getId());
        updatePo.setApplyOrderId(commodityOrderPO.getApplyOrderId());
        updatePo.setUpdateTime(new Date());
        updatePo.setUpdateUserId(reqBO.getUpdateUserId());
        updatePo.setUpdateUserName(reqBO.getUpdateUserName());
        updatePo.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus());
        bcmApplyCommodityOrderMapper.update(updatePo);
    }
}
