package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmVerifyIsMinPriceService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateApplyOrderSelectTimeLimitConfReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmVerifyIsMinPriceReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmVerifyIsMinPriceRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

/**
 * 类名：BcmVerifyIsMinPriceServiceImpl
 * 说明：描述一下类的作用
 * 时间：2023/12/11
 * 作者：pengyuqi
 */
@HTServiceImpl
public class BcmVerifyIsMinPriceServiceImpl implements BcmVerifyIsMinPriceService {
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;
    @Autowired
    private BcmApplyCommodityOrderItemMapper bcmApplyCommodityOrderItemMapper;

    @Override
    public BcmVerifyIsMinPriceRspBO verifyIsMinPrice(BcmVerifyIsMinPriceReqBO reqBO) {
        verifyParam(reqBO);
        BcmVerifyIsMinPriceRspBO rspBO = new BcmVerifyIsMinPriceRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        //默认为最低价
        rspBO.setIsMinPrice(true);
        //查询申请单明细
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItemPO =
                bcmApplyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrderItemPO == null) {
            throw new ZTBusinessException("查询上架申请单详情为空");
        }
        //查询明细排序找出最低价
        BcmQueryApplyCommodityOrderSupplierReplyItemPO qryItemPo = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        qryItemPo.setApplyOrderId(reqBO.getApplyOrderId());
        List<BcmApplyCommodityOrderSupplierReplyItemPO> itemMapperList = bcmApplyCommodityOrderSupplierReplyItemMapper.getList(qryItemPo);

        BcmApplyCommodityOrderSupplierReplyItemPO miniPrice =
                null;
        if (!CollectionUtils.isEmpty(itemMapperList)) {
            miniPrice = itemMapperList.stream()
                    .filter(e -> !ObjectUtils.isEmpty(e.getSalePrice()))
                    .min(Comparator.comparing(BcmApplyCommodityOrderSupplierReplyItemPO::getSalePrice))
                    .orElse(null);
        }
        if (null != miniPrice && !ObjectUtils.isEmpty(miniPrice.getSalePrice())) {
            rspBO.setMinPrice(BigDecimal.valueOf(miniPrice.getSalePrice()));
        } else {
            rspBO.setMinPrice(bcmApplyCommodityOrderItemPO.getStartShootPrice());
        }
        //不为空
        if (!ObjectUtils.isEmpty(rspBO.getMinPrice())
                //如果任何一个明细中的销售价小于等于的传入的单价 直接返回false
                && rspBO.getMinPrice().compareTo(reqBO.getSalePrice()) <= 0) {
            rspBO.setIsMinPrice(false);
            return rspBO;
        }
        return rspBO;
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmVerifyIsMinPriceReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getApplyOrderId() == null) {
            throw new ZTBusinessException("参数applyOrderId不能为null");
        }
        if (reqBO.getSalePrice() == null) {
            throw new ZTBusinessException("参数单价salePrice不能为null");
        }
    }
}
