package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmBranchBankRelevanceInvoiceService;
import com.tydic.bcm.personal.common.bo.BcmBranchBankRelevanceInvoiceReqBO;
import com.tydic.bcm.personal.common.bo.BcmBranchBankRelevanceInvoiceRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBranchBankInvoiceRelaMapper;
import com.tydic.bcm.personal.dao.BcmBranchBankMapper;
import com.tydic.bcm.personal.po.BcmBranchBankInvoiceRelaPO;
import com.tydic.bcm.personal.po.BcmBranchBankInvoiceRelaQueryPO;
import com.tydic.bcm.personal.po.BcmBranchBankPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题 BcmBranchBankRelevanceInvoiceServiceImpl
 * 说明
 * 时间 2023/9/12 10:05
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmBranchBankRelevanceInvoiceServiceImpl implements BcmBranchBankRelevanceInvoiceService {

    @Autowired
    private BcmBranchBankInvoiceRelaMapper branchBankInvoiceRelaMapper;

    @Autowired
    private BcmBranchBankMapper branchBankMapper;

    @Override
    public BcmBranchBankRelevanceInvoiceRspBO relevanceInvoice(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //校验分行是否存在
        checkBranchBank(reqBO);
        if (BcmPersonalCommonConstant.OperType.ADD.equals(reqBO.getOperaType())) {
            //新增分行与发票关联
            addBranchBankInvoice(reqBO);
        } else if (BcmPersonalCommonConstant.OperType.UPDATE.equals(reqBO.getOperaType())) {
            //删除分行发票关联关系
            deleteBranchBankInvoice(reqBO);
        } else {
            throw new ZTBusinessException("错误的操作类型");
        }

        //更新分行信息
        updateBranchBank(reqBO);
        return BcmRuUtil.success(BcmBranchBankRelevanceInvoiceRspBO.class);
    }

    /**
     * 删除分行发票关联关系
     *
     * @param reqBO
     */
    private void deleteBranchBankInvoice(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        BcmBranchBankInvoiceRelaQueryPO bcmBranchBankInvoiceRelaQueryPO = new BcmBranchBankInvoiceRelaQueryPO();
        bcmBranchBankInvoiceRelaQueryPO.setInvoiceIdList(reqBO.getInvoiceIdList());
        bcmBranchBankInvoiceRelaQueryPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        branchBankInvoiceRelaMapper.delete(bcmBranchBankInvoiceRelaQueryPO);
    }
    /**
     * 校验分行是否存在
     *
     * @param reqBO
     */
    private void checkBranchBank(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        BcmBranchBankPO bcmBranchBankPO = new BcmBranchBankPO();
        bcmBranchBankPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        BcmBranchBankPO model = branchBankMapper.getModel(bcmBranchBankPO);
        if (model == null) {
            throw new ZTBusinessException("不存在此分行");
        }
    }

    /**
     * 更新分行信息
     *
     * @param reqBO
     */
    private void updateBranchBank(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        BcmBranchBankPO bcmBranchBankPO = new BcmBranchBankPO();
        bcmBranchBankPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        bcmBranchBankPO.setUpdateTime(new Date());
        branchBankMapper.update(bcmBranchBankPO);
    }

    /**
     * 新增分行与发票关联
     *
     * @param reqBO
     */
    private void addBranchBankInvoice(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        List<BcmBranchBankInvoiceRelaPO> bcmBranchBankInvoiceRelaPOS = new ArrayList<>(reqBO.getInvoiceIdList().size());
        for (Long invoiceId : reqBO.getInvoiceIdList()) {
            BcmBranchBankInvoiceRelaPO bcmBranchBankInvoiceRelaPO = new BcmBranchBankInvoiceRelaPO();
            bcmBranchBankInvoiceRelaPO.setId(BcmIdUtil.nextId());
            bcmBranchBankInvoiceRelaPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
            bcmBranchBankInvoiceRelaPO.setInvoiceId(invoiceId);
            bcmBranchBankInvoiceRelaPOS.add(bcmBranchBankInvoiceRelaPO);
        }
        branchBankInvoiceRelaMapper.insertBach(bcmBranchBankInvoiceRelaPOS);
    }


    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (StringUtils.isBlank(reqBO.getBranchBankOrgId())) {
            throw new ZTBusinessException("入参分行机构id不能为null");
        }
        if (CollectionUtils.isEmpty(reqBO.getInvoiceIdList())) {
            throw new ZTBusinessException("入参发票id集合不能为null");
        }
        if (reqBO.getOperaType() == null) {
            throw new ZTBusinessException("入参操作类型不能为null");
        }
    }
}
