package com.tydic.bcm.personal.common.impl;

import com.tydic.bcm.personal.common.api.BcmDelBranchBankInvoiceRelaService;
import com.tydic.bcm.personal.common.bo.BcmDelBranchBankInvoiceRelaReqBO;
import com.tydic.bcm.personal.common.bo.BcmDelBranchBankInvoiceRelaRspBO;
import com.tydic.bcm.personal.dao.BcmBranchBankInvoiceRelaMapper;
import com.tydic.bcm.personal.po.BcmBranchBankInvoiceRelaQueryPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题 BcmDelBranchBankInvoiceRelaServiceImpl
 * 说明 删除分行与发票关联
 * 时间 2023/9/12 11:07
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmDelBranchBankInvoiceRelaServiceImpl implements BcmDelBranchBankInvoiceRelaService {

    @Autowired
    private BcmBranchBankInvoiceRelaMapper bcmBranchBankInvoiceRelaMapper;

    /**
     * 删除分行与发票关联
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmDelBranchBankInvoiceRelaRspBO delBranchBankInvoiceRela(BcmDelBranchBankInvoiceRelaReqBO reqBO) {
        BcmBranchBankInvoiceRelaQueryPO bcmBranchBankInvoiceRelaQueryPO = BcmRuUtil.js(reqBO, BcmBranchBankInvoiceRelaQueryPO.class);
        bcmBranchBankInvoiceRelaMapper.delete(bcmBranchBankInvoiceRelaQueryPO);
        return BcmRuUtil.success(BcmDelBranchBankInvoiceRelaRspBO.class);
    }
}
