package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFmisOrgsUpdateBatchService;
import com.tydic.bcm.personal.common.bo.BcmUpdateBatchSyncResultReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateBatchSyncResultRspBO;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.po.BcmQueryOrgOrgsFmisPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题 BcmFmisOrgsUpdateBatchServiceImpl
 * 说明 交行导入-财务组织同步结果修改(批量)实现
 * 时间 2023/8/15 11:29
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmFmisOrgsUpdateBatchServiceImpl implements BcmFmisOrgsUpdateBatchService {

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    /**
     * 财务组织同步结果修改(批量)实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmUpdateBatchSyncResultRspBO updateBatchSyncResult(BcmUpdateBatchSyncResultReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        BcmQueryOrgOrgsFmisPO update = BcmRuUtil.js(reqBO, BcmQueryOrgOrgsFmisPO.class);
        bcmOrgOrgsFmisMapper.updateBatchById(update);
        return BcmRuUtil.success(BcmUpdateBatchSyncResultRspBO.class);
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmUpdateBatchSyncResultReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
        if (reqBO.getDealTime() == null) {
            throw new ZTBusinessException("入参处理时间不能为null");
        }
        if (StringUtils.isBlank(reqBO.getDealResult())) {
            throw new ZTBusinessException("入参处理结果不能为null");
        }
        if (!BcmDealResultEnum.FAIL.getDealResult().equals(reqBO.getDealResult())
                || !BcmDealResultEnum.SUCCESS.getDealResult().equals(reqBO.getDealResult())
                || !BcmDealResultEnum.SKIP.getDealResult().equals(reqBO.getDealResult())) {
            throw new ZTBusinessException("入参处理结果状态值错误");
        }
        if (CollectionUtils.isEmpty(reqBO.getIdList())) {
            throw new ZTBusinessException("入参组织主键集合不能为null");
        }
    }
}
