package com.tydic.bcm.personal.common.impl;

import com.tydic.bcm.personal.common.api.BcmQueryBranchBankInvoiceRelaListService;
import com.tydic.bcm.personal.common.bo.BcmBranchBankInvoiceRelaBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBranchBankInvoiceRelaListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBranchBankInvoiceRelaListRspBO;
import com.tydic.bcm.personal.dao.BcmBranchBankInvoiceRelaMapper;
import com.tydic.bcm.personal.po.BcmBranchBankInvoiceRelaPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryBranchBankInvoiceRelaListServiceImpl
 * 说明 分行与发票关联列表查询
 * 时间 2023/9/12 10:59
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryBranchBankInvoiceRelaListServiceImpl implements BcmQueryBranchBankInvoiceRelaListService {

    @Autowired
    private BcmBranchBankInvoiceRelaMapper bcmBranchBankInvoiceRelaMapper;

    /**
     * 分行与发票关联列表查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBranchBankInvoiceRelaListRspBO queryBranchBankInvoiceRelaList(BcmQueryBranchBankInvoiceRelaListReqBO reqBO) {
        BcmBranchBankInvoiceRelaPO bcmBranchBankInvoiceRelaPO = BcmRuUtil.js(reqBO, BcmBranchBankInvoiceRelaPO.class);
        List<BcmBranchBankInvoiceRelaPO> list = bcmBranchBankInvoiceRelaMapper.getList(bcmBranchBankInvoiceRelaPO);
        BcmQueryBranchBankInvoiceRelaListRspBO rspBO = BcmRuUtil.success(BcmQueryBranchBankInvoiceRelaListRspBO.class);
        rspBO.setList(BcmRuUtil.jsl(list, BcmBranchBankInvoiceRelaBO.class));
        return rspBO;
    }
}
