package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryBudgetModeConfigPageListService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetModeConfigMapper;
import com.tydic.bcm.personal.po.BcmBudgetModeConfigPO;
import com.tydic.bcm.personal.po.BcmBudgetModeConfigPagePO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名： BcmQueryBudgetModeConfigPageListServiceImpl
 * 说明：预算模式设置-预算模式列表查询(分页)实现
 *
 * @author： lishiqing
 * 时间： 2023/7/24 9:54
 */
@HTServiceImpl
public class BcmQueryBudgetModeConfigPageListServiceImpl implements BcmQueryBudgetModeConfigPageListService {


    @Autowired
    private BcmBudgetModeConfigMapper bcmBudgetModeConfigMapper;

    /**
     * 预算模式列表查询(分页)
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBudgetModeConfigPageListRspBO queryBudgetModeConfigPageList(BcmQueryBudgetModeConfigPageListReqBO reqBO) {
        BcmQueryBudgetModeConfigPageListRspBO rspBO = new BcmQueryBudgetModeConfigPageListRspBO();
        // 入参组装
        Page<BcmBudgetModeConfigPagePO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        BcmBudgetModeConfigPagePO budgetModeConfigPagePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmBudgetModeConfigPagePO.class);
        budgetModeConfigPagePO.setSortName("UPDATE_TIME");
        budgetModeConfigPagePO.setSortOrder("DESC");


        // 根据条件分页查询列表数据
        List<BcmBudgetModeConfigPO> bcmBudgetModeConfigPOList =  bcmBudgetModeConfigMapper.getPageList(budgetModeConfigPagePO,page);

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(JSONObject.parseArray(JSONObject.toJSONString(bcmBudgetModeConfigPOList), BcmBudgetModeConfigBO.class));
        rspBO.getRows().forEach(item -> {
            item.setBudgetModeStr(BcmPersonalCommonConstant.BudgetMode.BudgetModeMap.get(item.getBudgetMode()));
        });

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
