package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryFmisOrgsPageListService;
import com.tydic.bcm.personal.common.bo.BcmFmisOrgsQueryPageReqBO;
import com.tydic.bcm.personal.common.bo.BcmFmisOrgsQueryPageRspBO;
import com.tydic.bcm.personal.common.bo.BcmOrgOrgsFmisBO;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.dao.BcmOrgOrgsFmisMapper;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmQueryOrgOrgsFmisPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryFmisOrgsPageListServiceImpl
 * 说明 交行导入-财务组织分页查询实现
 * 时间 2023/8/15 10:11
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryFmisOrgsPageListServiceImpl implements BcmQueryFmisOrgsPageListService {

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    /**
     * 财务组织分页查询实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmFmisOrgsQueryPageRspBO queryFmisOrgPageList(BcmFmisOrgsQueryPageReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmQueryOrgOrgsFmisPO bcmQueryOrgOrgsFmisPO = getBcmQueryOrgOrgsFmisPO(reqBO);
        Page<BcmOrgOrgsFmisPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmOrgOrgsFmisPO> pageList = bcmOrgOrgsFmisMapper.getPageList(bcmQueryOrgOrgsFmisPO, page);
        return setRspBo(pageList, page);
    }

    /**
     * 参数组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryOrgOrgsFmisPO getBcmQueryOrgOrgsFmisPO(BcmFmisOrgsQueryPageReqBO reqBO) {
        BcmQueryOrgOrgsFmisPO bcmQueryOrgOrgsFmisPO = BcmRuUtil.js(reqBO, BcmQueryOrgOrgsFmisPO.class);
        bcmQueryOrgOrgsFmisPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        return bcmQueryOrgOrgsFmisPO;
    }

    /**
     * 出参组装
     *
     * @param pageList
     * @param page
     * @return
     */
    private BcmFmisOrgsQueryPageRspBO setRspBo(List<BcmOrgOrgsFmisPO> pageList, Page<BcmOrgOrgsFmisPO> page) {
        BcmFmisOrgsQueryPageRspBO rspBO = BcmRuUtil.success(BcmFmisOrgsQueryPageRspBO.class);
        rspBO.setRows(BcmRuUtil.jsl(pageList, BcmOrgOrgsFmisBO.class));
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmFmisOrgsQueryPageReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
