package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryOrderFirstAuditorPageListService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.dao.BcmOrderFirstAuditorMapper;
import com.tydic.bcm.personal.po.BcmOrderFirstAuditorPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名： BcmQueryOrderFirstAuditorPageListServiceImpl
 * 说明：订单一级审核人查询（分页）实现
 *
 * @author： lishiqing
 * 时间： 2023/9/26 16:23
 */
@HTServiceImpl
public class BcmQueryOrderFirstAuditorPageListServiceImpl implements BcmQueryOrderFirstAuditorPageListService {

    @Autowired
    private BcmOrderFirstAuditorMapper bcmOrderFirstAuditorMapper;

    @Override
    public BcmQueryOrderFirstAuditorPageListRspBO queryOrderFirstAuditorPageList(BcmQueryOrderFirstAuditorPageListReqBO reqBO) {
        BcmQueryOrderFirstAuditorPageListRspBO rspBO = new BcmQueryOrderFirstAuditorPageListRspBO();

        // 入参组装
        Page<BcmOrderFirstAuditorPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        BcmOrderFirstAuditorPO qryPO = JSONObject.parseObject(JSON.toJSONString(reqBO), BcmOrderFirstAuditorPO.class);

        // 根据条件关联采购用途表分页查询列表数据
        List<BcmOrderFirstAuditorPO> poList =  bcmOrderFirstAuditorMapper.getPageList(qryPO,page);

        // 出参组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(JSONObject.parseArray(JSONObject.toJSONString(poList), BcmOrderFirstAuditorBO.class));

        // 如果结果为空直接返回
        if (ObjectUtil.isEmpty(rspBO.getRows())) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
