package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryPurchasePurposeRelaCatalogService;
import com.tydic.bcm.personal.common.bo.BcmAddPurchasePurposeConfigCatalogInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryPurchasePurposeRelaCatalogReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryPurchasePurposeRelaCatalogRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndCommodityCategoryMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndCommodityCategoryPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 描述: 〈采购用途配置-查询已关商品类目实现类〉
 *
 * @author : yuhao
 * @date : 2023/10/13 15:33
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@HTServiceImpl
public class BcmQueryPurchasePurposeRelaCatalogServiceImpl implements BcmQueryPurchasePurposeRelaCatalogService {

    @Autowired
    private BcmPurchasePurposeAndCommodityCategoryMapper bcmPurchasePurposeAndCommodityCategoryMapper;

    @Override
    public BcmQueryPurchasePurposeRelaCatalogRspBO queryPurchasePurposeRelaCatalog(BcmQueryPurchasePurposeRelaCatalogReqBO reqBO) {
        BcmQueryPurchasePurposeRelaCatalogRspBO rspBO = new BcmQueryPurchasePurposeRelaCatalogRspBO();

        // 校验
        judge(reqBO);

        BcmPurchasePurposeAndCommodityCategoryPO qryPO = new BcmPurchasePurposeAndCommodityCategoryPO();
        qryPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        qryPO.setPurchasePurposeId(reqBO.getPurchasePurposeId());
        List<BcmPurchasePurposeAndCommodityCategoryPO> list = bcmPurchasePurposeAndCommodityCategoryMapper.getList(qryPO);
        if (!CollectionUtils.isEmpty(list)) {
            rspBO.setCatalogList(JUtil.jsl(list, BcmAddPurchasePurposeConfigCatalogInfoBO.class));
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 入参校验
     *
     * @param reqBO
     */
    void judge(BcmQueryPurchasePurposeRelaCatalogReqBO reqBO) {
        if (reqBO.getPurchasePurposeId() == null) {
            throw new ZTBusinessException("采购用途关联商品类目查询【purchasePurposeId】为空");
        }
    }
}
