package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQueryRelPurchasePurposeForOrgNameListService;
import com.tydic.bcm.personal.common.bo.BcmQueryRelPurchasePurposeForOrgNameListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryRelPurchasePurposeForOrgNameListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： BcmQueryRelPurchasePurposeForOrgNameListServiceImpl
 * 说明：采购用途配置-已关联采购用途的收支项目列表查询实现
 *
 * @author： lishiqing
 * 时间： 2023/7/24 17:17
 */
@HTServiceImpl
public class BcmQueryRelPurchasePurposeForOrgNameListServiceImpl implements BcmQueryRelPurchasePurposeForOrgNameListService {

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    @Override
    public BcmQueryRelPurchasePurposeForOrgNameListRspBO queryRelPurchasePurposeForOrgNameList(BcmQueryRelPurchasePurposeForOrgNameListReqBO reqBO) {
        BcmQueryRelPurchasePurposeForOrgNameListRspBO rspBO = new BcmQueryRelPurchasePurposeForOrgNameListRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmPurchasePurposeAndPaymentProjectRelPO qryPO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        qryPO.setPurchasePurposeId(reqBO.getPurchasePurposeId());
        qryPO.setRelStatus(BcmPersonalCommonConstant.RelStatus.ASSOCIATED);
        List<BcmPurchasePurposeAndPaymentProjectRelPO> purposeAndPaymentProjectRelPOS = bcmPurchasePurposeAndPaymentProjectRelMapper.getList(qryPO);

        if (ObjectUtil.isEmpty(purposeAndPaymentProjectRelPOS)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("未查询到符合条件的数据");
            return rspBO;
        }

        // 获取已关联的机构名称集合
        List<String> orgNameList = purposeAndPaymentProjectRelPOS.stream().map(BcmPurchasePurposeAndPaymentProjectRelPO::getCreateOrgName).collect(Collectors.toList());
        rspBO.setOrgNameList(orgNameList);

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryRelPurchasePurposeForOrgNameListReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("已关联采购用途的收支项目列表查询入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeId())) {
            throw new ZTBusinessException("已关联采购用途的收支项目列表查询入参采购用途ID【purchasePurposeId】为空");
        }
    }
}
