package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmReTryInSystemCallLogService;
import com.tydic.bcm.personal.common.bo.BcmReTryInSystemCallLogReqBO;
import com.tydic.bcm.personal.common.bo.BcmReTryInSystemCallLogRspBO;
import com.tydic.bcm.personal.common.bo.InSystemCallLogBO;
import com.tydic.bcm.personal.dao.InSystemCallLogMapper;
import com.tydic.bcm.personal.po.InSystemCallLogPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.List;

@HTServiceImpl
public class BcmReTryInSystemCallLogServiceImpl implements BcmReTryInSystemCallLogService {

    @Autowired
    private InSystemCallLogMapper inSystemCallLogMapper;

    // 重试失败次数
    @Value("${failTurn:3}")
    private Integer failTurn;

    @Override
    public BcmReTryInSystemCallLogRspBO reTryInSystemCallLog(BcmReTryInSystemCallLogReqBO reqBO) {

        Page<InSystemCallLogPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        InSystemCallLogPO po = JUtil.js(reqBO, InSystemCallLogPO.class);
        po.setMaxFailTurn(failTurn);
        po.setCallResult(1);


        List<InSystemCallLogPO> listPage = inSystemCallLogMapper.getListPage(po, page);
        List<InSystemCallLogBO> rows = JUtil.jsl(listPage, InSystemCallLogBO.class);


        BcmReTryInSystemCallLogRspBO rspBO = new BcmReTryInSystemCallLogRspBO();
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

}
