package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.bcm.personal.common.api.BcmUpdatePurchasePurposeConfigService;
import com.tydic.bcm.personal.common.bo.BcmAddPurchasePurposeConfigCatalogInfoBO;
import com.tydic.bcm.personal.common.bo.BcmUpdatePurchasePurposeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdatePurchasePurposeConfigRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndCommodityCategoryMapper;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndCommodityCategoryPO;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.utils.JUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 类名： BcmUpdatePurchasePurposeConfigServiceImpl
 * 说明：采购用途设置-采购用途修改实现
 *
 * @author： lishiqing
 * 时间： 2023/7/21 14:11
 */
@HTServiceImpl
public class BcmUpdatePurchasePurposeConfigServiceImpl implements BcmUpdatePurchasePurposeConfigService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;
    @Autowired
    private BcmPurchasePurposeAndCommodityCategoryMapper bcmPurchasePurposeAndCommodityCategoryMapper;

    /**
     * 采购用途修改
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmUpdatePurchasePurposeConfigRspBO updatePurchasePurposeConfig(BcmUpdatePurchasePurposeConfigReqBO reqBO) {
        BcmUpdatePurchasePurposeConfigRspBO rspBO = new BcmUpdatePurchasePurposeConfigRspBO();
        // 参数校验
        verifyParam(reqBO);

        //入参组装
        BcmPurchasePurposeConfigPO updatePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPurchasePurposeConfigPO.class);
        updatePO.setUpdateTime(new Date());

        // 根据ID修改单条数据
        int i = bcmPurchasePurposeConfigMapper.updateById(updatePO);
        if (i < 1) {
            throw new ZTBusinessException("采购用途修改失败");
        }


        // 处理采购用途关联的类目
        dealRelCatalogUpdate(reqBO);


        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 处理采购用途关联的类目
     *
     * @param reqBO
     */
    private void dealRelCatalogUpdate(BcmUpdatePurchasePurposeConfigReqBO reqBO) {
        // 先假删除所有以前的关联的类目
        BcmPurchasePurposeAndCommodityCategoryPO set = new BcmPurchasePurposeAndCommodityCategoryPO();
        set.setUpdateUserId(reqBO.getUpdateUserId());
        set.setUpdateUserName(reqBO.getUpdateUserName());
        set.setUpdateTime(new Date(System.currentTimeMillis()));
        set.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
        BcmPurchasePurposeAndCommodityCategoryPO where = new BcmPurchasePurposeAndCommodityCategoryPO();
        where.setPurchasePurposeId(reqBO.getPurchasePurposeId());
        bcmPurchasePurposeAndCommodityCategoryMapper.updateBy(set, where);

        // 然后新增现在关联的类目
        List<BcmPurchasePurposeAndCommodityCategoryPO> insertList = new ArrayList<>();
        for (BcmAddPurchasePurposeConfigCatalogInfoBO each : reqBO.getCatalogList()) {
            BcmPurchasePurposeAndCommodityCategoryPO insertCatalogPO = JUtil.js(each, BcmPurchasePurposeAndCommodityCategoryPO.class);
            insertCatalogPO.setId(Sequence.getInstance().nextId());
            insertCatalogPO.setPurchasePurposeId(reqBO.getPurchasePurposeId());
            insertCatalogPO.setPurchasePurposeName(reqBO.getPurchasePurposeName());
            insertCatalogPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            insertCatalogPO.setCreateTime(set.getUpdateTime());
            insertCatalogPO.setCreateUserId(reqBO.getUpdateUserId());
            insertCatalogPO.setCreateUserName(reqBO.getUpdateUserName());
            insertList.add(insertCatalogPO);
        }
        bcmPurchasePurposeAndCommodityCategoryMapper.insertBatch(insertList);
    }


    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmUpdatePurchasePurposeConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途修改入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeId())) {
            throw new ZTBusinessException("采购用途修改入参主键ID【purchasePurposeId】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeName())) {
            throw new ZTBusinessException("采购用途修改入参采购用途名称【purchasePurposeName】不能为空");
        }
        if (!CollectionUtils.isEmpty(reqBO.getCatalogList())) {
            for (BcmAddPurchasePurposeConfigCatalogInfoBO each : reqBO.getCatalogList()) {
                if (ObjectUtil.isEmpty(each.getFirstCatalogId())) {
                    throw new ZTBusinessException("采购用途新增入参采购一级商品类目ID【firstCatalogId】为空");
                }
                if (ObjectUtil.isEmpty(each.getFirstCatalogName())) {
                    throw new ZTBusinessException("采购用途新增入参采购一级商品类目名称【firstCatalogName】为空");
                }
            }
        } else {
            throw new ZTBusinessException("采购用途新增入参采购用途商品类目集合【catalogList】为空");
        }
    }

}
