package com.tydic.bcm.personal.common.impl;

import com.tydic.bcm.personal.common.api.BcmVerifyPurchasePurposeConfigService;
import com.tydic.bcm.personal.common.bo.BcmVerifyPurchasePurposeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmVerifyPurchasePurposeConfigtRspBO;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

@HTServiceImpl
public class BcmVerifyPurchasePurposeConfigServiceImpl implements BcmVerifyPurchasePurposeConfigService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;

    @Override
    public BcmVerifyPurchasePurposeConfigtRspBO verifyPurchasePurposeConfig(BcmVerifyPurchasePurposeConfigReqBO reqBO) {
        BcmVerifyPurchasePurposeConfigtRspBO rspBO = new BcmVerifyPurchasePurposeConfigtRspBO();

        if (StringUtils.isEmpty(reqBO.getProcurementPurposeName())) {
            rspBO.setRespCode(BaseRspConstant.RSP_DESC_FAIL);
            rspBO.setRespDesc("入参【采购用途名称】为空");
            return rspBO;
        }

        BcmPurchasePurposeConfigPO qryPO = new BcmPurchasePurposeConfigPO();
        qryPO.setPurchasePurposeNameAcc(reqBO.getProcurementPurposeName());
        List<BcmPurchasePurposeConfigPO> list = bcmPurchasePurposeConfigMapper.getList(qryPO);

        if (CollectionUtils.isEmpty(list)) {
            rspBO.setIsExist(1);
        } else {
            rspBO.setIsExist(0);
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
