package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmAddressGroupPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：地址分组表
 *
 * @author Lihulin
 * @date 2023-11-13 15:04
 **/
@Mapper
@Repository
public interface BcmAddressGroupMapper {

    /**
     * 插入单条数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return int 影响数量
     */
    int insert(BcmAddressGroupPO bcmAddressGroupPo);

    /**
     * 根据条件删除数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return int 影响数量
     */
    int deleteBy(BcmAddressGroupPO bcmAddressGroupPo);

    /**
     * 根据主键更新数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
     */
    @Deprecated
    int updateById(BcmAddressGroupPO bcmAddressGroupPo);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmAddressGroupPO set, @Param("where") BcmAddressGroupPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(BcmAddressGroupPO bcmAddressGroupPo);

    /**
     * 根据条件查询单条数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return BcmAddressGroupPO 结果对象
     */
    BcmAddressGroupPO getModelBy(BcmAddressGroupPO bcmAddressGroupPo);

    /**
     * 根据条件查询列表数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return List<BcmAddressGroupPO> 结果对象
     */
    List<BcmAddressGroupPO> getList(BcmAddressGroupPO bcmAddressGroupPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @param page              分页参数
     * @return List<BcmAddressGroupPO> 结果对象
     */
    List<BcmAddressGroupPO> getListPage(BcmAddressGroupPO bcmAddressGroupPo, Page<BcmAddressGroupPO> page);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<BcmAddressGroupPO> list);


    /**
     * 根据条件 关联bcm_address_group_rela_address表查询列表数据
     *
     * @param bcmAddressGroupPo 参数对象
     * @return List<BcmAddressGroupPO> 结果对象
     */
    List<BcmAddressGroupPO> getListJoinRel(BcmAddressGroupPO bcmAddressGroupPo);

}
