package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndCommodityCategoryPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：采购用途与商品类目关系表
 *
 * @author Lihulin
 * @date 2023-10-13 15:02
 **/
@Mapper
@Repository
public interface BcmPurchasePurposeAndCommodityCategoryMapper {

    /**
     * 插入单条数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @return int 影响数量
     */
    int insert(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo);

    /**
     * 根据条件删除数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @return int 影响数量
     */
    int deleteBy(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo);

    /**
     * 根据主键更新数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
     */
    int updateById(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmPurchasePurposeAndCommodityCategoryPO set, @Param("where") BcmPurchasePurposeAndCommodityCategoryPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo);

    /**
     * 根据条件查询单条数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @return BcmPurchasePurposeAndCommodityCategoryPO 结果对象
     */
    BcmPurchasePurposeAndCommodityCategoryPO getModelBy(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo);

    /**
     * 根据条件查询列表数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @return List<BcmPurchasePurposeAndCommodityCategoryPO> 结果对象
     */
    List<BcmPurchasePurposeAndCommodityCategoryPO> getList(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param bcmPurchasePurposeAndCommodityCategoryPo 参数对象
     * @param page                                     分页参数
     * @return List<BcmPurchasePurposeAndCommodityCategoryPO> 结果对象
     */
    List<BcmPurchasePurposeAndCommodityCategoryPO> getListPage(BcmPurchasePurposeAndCommodityCategoryPO bcmPurchasePurposeAndCommodityCategoryPo, Page<BcmPurchasePurposeAndCommodityCategoryPO> page);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<BcmPurchasePurposeAndCommodityCategoryPO> list);

}
