package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmFinancialOrgRelPurPurposePO;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelExtendPO;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 类名： BcmPurchasePurposeAndPaymentProjectRelMapper
 * 说明：采购用途与收支项目关联Mapper
 *
 * @author： lishiqing
 * 时间： 2023/7/21 14:51
 */
@Mapper
@Repository
public interface BcmPurchasePurposeAndPaymentProjectRelMapper {
    /**
     * 根据条件查询列表数据
     *
     * @param po 参数对象
     * @return List<BcmPurchasePurposeAndPaymentProjectRelPO> 结果对象
     */
    List<BcmPurchasePurposeAndPaymentProjectRelPO> getList(BcmPurchasePurposeAndPaymentProjectRelPO po);

    /**
     * 根据条件关联采购用途表分页查询列表数据
     *
     * @param po   参数对象
     * @param page 分页参数
     * @return List<BcmPurchasePurposeAndPaymentProjectRelPO> 结果对象
     */
    List<BcmPurchasePurposeAndPaymentProjectRelExtendPO> queryMyPurchasePurposePageList(BcmPurchasePurposeAndPaymentProjectRelExtendPO po, Page<BcmPurchasePurposeAndPaymentProjectRelExtendPO> page);

    /**
     * 插入单条数据
     *
     * @param po 参数对象
     * @return int 影响数量
     */
    int insert(BcmPurchasePurposeAndPaymentProjectRelPO po);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmPurchasePurposeAndPaymentProjectRelPO set, @Param("where") BcmPurchasePurposeAndPaymentProjectRelPO where);

    /**
     * 根据条件查询单条数据
     *
     * @param po 参数对象
     * @return BcmPurchasePurposeAndPaymentProjectRelPO 结果对象
     */
    BcmPurchasePurposeAndPaymentProjectRelPO getModelBy(BcmPurchasePurposeAndPaymentProjectRelPO po);

    /**
     * @param po 参数对象
     * @return List<BcmFinancialOrgRelPurPurposePO> 结果对象
     */
    List<BcmFinancialOrgRelPurPurposePO> queryFinancialOrgRelPurPurposeList(BcmFinancialOrgRelPurPurposePO po);

    /**
     * @return List<BcmFinancialOrgRelPurPurposePO> 结果对象
     */
    List<BcmFinancialOrgRelPurPurposePO> queryFinancialOrgRelPurPurposeListInCommon();
}
