package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmReplaceAddressSkuPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：代下单地址商品
 * 
 * @author Lihulin
 * @date 2023-11-15 15:13
 **/
@Mapper
@Repository
public interface BcmReplaceAddressSkuMapper {

	/**
	 * 插入单条数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @return int 影响数量
	 */
	int insert(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") BcmReplaceAddressSkuPO set, @Param("where") BcmReplaceAddressSkuPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @return BcmReplaceAddressSkuPO 结果对象
	 */
	BcmReplaceAddressSkuPO getModelBy(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @return List<BcmReplaceAddressSkuPO> 结果对象
	 */
	List<BcmReplaceAddressSkuPO> getList(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param bcmReplaceAddressSkuPo 参数对象
	 * @param page 分页参数
	 * @return List<BcmReplaceAddressSkuPO> 结果对象
	 */
	List<BcmReplaceAddressSkuPO> getListPage(BcmReplaceAddressSkuPO bcmReplaceAddressSkuPo, Page<BcmReplaceAddressSkuPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<BcmReplaceAddressSkuPO> list);

}
