package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.InSystemCallLogPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：商城内部调用日志记录表
 *
 * @author Lihulin
 * @date 2024-01-08 15:27
 **/
@Mapper
@Repository
public interface InSystemCallLogMapper {

    /**
     * 插入单条数据
     *
     * @param inSystemCallLogPo 参数对象
     * @return int 影响数量
     */
    int insert(InSystemCallLogPO inSystemCallLogPo);

    /**
     * 根据条件删除数据
     *
     * @param inSystemCallLogPo 参数对象
     * @return int 影响数量
     */
    int deleteBy(InSystemCallLogPO inSystemCallLogPo);

    /**
     * 根据主键更新数据
     *
     * @param inSystemCallLogPo 参数对象
     * @return int 影响数量
     * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
     */
    @Deprecated
    int updateById(InSystemCallLogPO inSystemCallLogPo);

    /**
     * 根据条件更新数据
     *
     * @param set   set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") InSystemCallLogPO set, @Param("where") InSystemCallLogPO where);

    /**
     * 根据条件校验有多少条数据
     *
     * @param inSystemCallLogPo 参数对象
     * @return int 总数量
     */
    int getCheckBy(InSystemCallLogPO inSystemCallLogPo);

    /**
     * 根据条件查询单条数据
     *
     * @param inSystemCallLogPo 参数对象
     * @return InSystemCallLogPO 结果对象
     */
    InSystemCallLogPO getModelBy(InSystemCallLogPO inSystemCallLogPo);

    /**
     * 根据条件查询列表数据
     *
     * @param inSystemCallLogPo 参数对象
     * @return List<InSystemCallLogPO> 结果对象
     */
    List<InSystemCallLogPO> getList(InSystemCallLogPO inSystemCallLogPo);

    /**
     * 根据条件分页查询列表数据
     *
     * @param inSystemCallLogPo 参数对象
     * @param page              分页参数
     * @return List<InSystemCallLogPO> 结果对象
     */
    List<InSystemCallLogPO> getListPage(InSystemCallLogPO inSystemCallLogPo, Page<InSystemCallLogPO> page);

    /**
     * 批量插入数据
     *
     * @param list 参数列表
     */
    void insertBatch(List<InSystemCallLogPO> list);

    /**
     * 修改为失败，且失败次数加一
     */
    void updateToFail(@Param("set") InSystemCallLogPO set, @Param("where") InSystemCallLogPO where);

}
