package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.TChnipmpSupplierUserExtendPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierUserPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * (IPMP)供应商账号;(t_chnipmp_supplier_user)表数据库访问层
 *
 * @author : civism
 * @date : 2023-8-17
 */
@Mapper
public interface TChnipmpSupplierUserMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TChnipmpSupplierUserPO queryById(Long id);

    /**
     * 分页查询指定行数据
     *
     * @param tChnipmpSupplierUser 查询条件
     * @param page                 分页对象
     * @return 对象列表
     */
    List<TChnipmpSupplierUserPO> queryAllByLimit(TChnipmpSupplierUserExtendPO tChnipmpSupplierUser, Page<TChnipmpSupplierUserPO> page);


    /**
     * 查询最近的用户id
     * @param userIdList
     * @param lastSyncDate
     * @return
     */
    List<TChnipmpSupplierUserPO> queryLastByUserId(List<String> userIdList, Date lastSyncDate);


    /**
     * 统计总行数
     *
     * @param tChnipmpSupplierUser 查询条件
     * @return 总行数
     */
    long count(TChnipmpSupplierUserPO tChnipmpSupplierUser);

    /**
     * 新增数据
     *
     * @param tChnipmpSupplierUser 实例对象
     * @return 影响行数
     */
    int insert(TChnipmpSupplierUserPO tChnipmpSupplierUser);

    /**
     * 批量新增数据
     *
     * @param entities List<TChnipmpSupplierUser> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<TChnipmpSupplierUserPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<TChnipmpSupplierUser> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<TChnipmpSupplierUserPO> entities);

    /**
     * 更新数据
     *
     * @param tChnipmpSupplierUser 实例对象
     * @return 影响行数
     */
    int update(TChnipmpSupplierUserPO tChnipmpSupplierUser);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);
}