package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名： BcmOrderFirstAuditorPO
 * 说明：订单一级审核人--PO
 *
 * @author： lishiqing
 * 时间： 2023/9/25 10:42
 */
@Data
public class BcmOrderFirstAuditorPO implements Serializable {
    private static final long serialVersionUID = 3075470593837194721L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 订单ID
     */
    private Long orderId;

    /**
     * 审批人ID
     */
    private Long auditUserId;

    /**
     * 审批人名称
     */
    private String auditUserName;

    /**
     * 审批人组织ID
     */
    private Long auditOrgId;

    /**
     * 审批人组织名称
     */
    private String auditOrgName;

    /**
     * 审批人公司ID
     */
    private Long auditCompanyId;

    /**
     * 审批人公司名称
     */
    private String auditCompanyName;

    /**
     * 审批人角色ids逗号分隔
     */
    private String auditUserRoleIds;

    /**
     * 审批人角色名称逗号分隔
     */
    private String auditUserRoleName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 删除标识
     */
    private Integer delFlag;
}
