package com.tydic.bcm.personal.po;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/18 10:57
 */
@EqualsAndHashCode(callSuper = false)
@Data
public class TChnipmpContractInfoExtendPO extends TChnipmpContractInfoPO {
    private static final long serialVersionUID = -2934332571629926351L;

    /**
     * 大于推送时间
     */
    private Date gtPushDate;

    /**
     * 小于推送时间
     */
    private Date ltPushDate;

    /**
     * 等于推送时间
     */
    private Date egPushDate;

    /**
     * 合同状态
     */
    private List<String> contractStatusList;

    /**
     * 税率
     */
    private String taxRate;


    private List<ArgFileInfoBO> agrAccessoryBOs;


    @Data

    public static class ArgFileInfoBO implements Serializable {

        private static final long serialVersionUID = 6573465780910625428L;

        /**
         * 附件类型(1:协议主体 2:协议明细 3:协议变更申请)
         */
        private Integer attachmentType;

        /**
         * 附件名称	 是
         */
        private String accessoryName;

        /**
         * 附件url	 是
         */
        private String accessoryUrl;

        /**
         * 附件编号	否
         */
        private String accessoryId;
    }
}
