package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;

/**
 * (IPMP)合同;智采平台基础数据临时表：合同
 *
 * @author : civism
 * @date : 2023-8-18
 */
@Data
public class TChnipmpContractInfoPO implements Serializable {
    private static final long serialVersionUID = -5828754576475522735L;
    /**
     * ID
     */
    private Long dataId;
    /**
     * 合同id
     */
    private String id;
    /**
     * 合同名称
     */
    private String contractName;
    /**
     * 合同编码
     */
    private String contractNo;
    /**
     * 合同状态;合同状态:00-新建；01-法审中；03-移交中；04-已移交；05-已接收
     * 06-履约中；07-履约完成；08-存在异常；09-变更中；10-变更完成
     * 11-续约中；12-续约完成；13-作废
     */
    private String contractStatus;
    /**
     * 项目id
     */
    private String projectId;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 项目编号
     */
    private String projectNo;
    /**
     * 项目类型
     */
    private String projectType;
    /**
     * 是否三方协议;是否三方协议:0-双方；1-三方
     */
    private String isTripartite;
    /**
     * 供应商名称
     */
    private String bName;
    /**
     * 供应商社会信用代码
     */
    private String bInsIdCd;
    /**
     * 供应商联系人
     */
    private String bLinkman;
    /**
     * 供应商联系人名称
     */
    private String bLinkmanName;
    /**
     * 供应商联系人电话
     */
    private String bLinkmanPhoneno;
    /**
     * 合同总金额含税
     */
    private BigDecimal contractSum;
    /**
     * 合同不含税金额
     */
    private BigDecimal contractSumExcludingTax;
    /**
     * 合同来源类别
     */
    private String contractSourceType;
    /**
     * 是否为IT类合同;是否为IT类合同：1-是；0-否
     */
    private String isItContract;
    /**
     * IT合同类型
     */
    private String assetinfoType;
    /**
     * 主办部门id
     */
    private String sponsorDeptId;
    /**
     * 主办部门名称
     */
    private String sponsorDeptName;
    /**
     * 主办部门编码
     */
    private String sponsorDeptCode;
    /**
     * 合同主办人id
     */
    private String aSponsorEmp;
    /**
     * 合同主办人名称
     */
    private String aSponsorName;
    /**
     * 合同主办人手机号
     */
    private String aSponsorPhoneno;
    /**
     * 归口部门id
     */
    private String centralizedDeptId;
    /**
     * 归口部门名称
     */
    private String centralizedDeptName;
    /**
     * 合同背景介绍
     */
    private String contractIntroduce;
    /**
     * 合同已用印文本ecmId;合同已用印文本ecmId（多个用逗号分隔）
     */
    private String fileEcm0301;
    /**
     * 合同已用印文本名称;合同已用印文本名称（多个用逗号分隔）
     */
    private String fileName0301;
    /**
     * 合同未用印文本ecmId;合同未用印文本ecmId（多个用逗号分隔）
     */
    private String fileEcm0305;
    /**
     * 合同未用印文本名称;合同未用印文本名称（多个用逗号分隔）
     */
    private String fileName0305;
    /**
     * 合同OA法审ecmId;合同OA法审ecmId（多个用逗号分隔）
     */
    private String fileEcm0306;
    /**
     * 合同OA法审名称;合同OA法审名称（多个用逗号分隔）
     */
    private String fileName0306;
    /**
     * 合同其他附件ecmId;合同其他附件ecmId（多个用逗号分隔）
     */
    private String fileEcm0304;
    /**
     * 合同其他附件名称;合同其他附件名称（多个用逗号分隔）
     */
    private String fileName0304;
    /**
     * 合同项目附件ecmId;合同项目附件ecmId（多个用逗号分隔）
     */
    private String fileEcm0314;
    /**
     * 合同项目附件名称;合同项目附件名称（多个用逗号分隔）
     */
    private String fileName0314;
    /**
     * 记录创建时间
     */
    private Date recCreateTime;
    /**
     * 记录修改时间
     */
    private Date recUpdTime;
    /**
     * 原合同编号
     */
    private String originContractNo;
    /**
     * 推送时间
     */
    private Date pushTime;
    /**
     * 处理时间
     */
    private Date dealTime;
    /**
     * 处理结果;处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TChnipmpContractInfoPO that = (TChnipmpContractInfoPO) o;
        return Objects.equals(id, that.id) && Objects.equals(contractName, that.contractName) && Objects.equals(contractNo, that.contractNo) && Objects.equals(contractStatus, that.contractStatus) && Objects.equals(projectId, that.projectId) && Objects.equals(projectName, that.projectName) && Objects.equals(projectNo, that.projectNo) && Objects.equals(projectType, that.projectType) && Objects.equals(isTripartite, that.isTripartite) && Objects.equals(bName, that.bName) && Objects.equals(bInsIdCd, that.bInsIdCd) && Objects.equals(bLinkman, that.bLinkman) && Objects.equals(bLinkmanName, that.bLinkmanName) && Objects.equals(bLinkmanPhoneno, that.bLinkmanPhoneno) && Objects.equals(contractSum, that.contractSum) && Objects.equals(contractSumExcludingTax, that.contractSumExcludingTax) && Objects.equals(contractSourceType, that.contractSourceType) && Objects.equals(isItContract, that.isItContract) && Objects.equals(assetinfoType, that.assetinfoType) && Objects.equals(sponsorDeptId, that.sponsorDeptId) && Objects.equals(sponsorDeptName, that.sponsorDeptName) && Objects.equals(sponsorDeptCode, that.sponsorDeptCode) && Objects.equals(aSponsorEmp, that.aSponsorEmp) && Objects.equals(aSponsorName, that.aSponsorName) && Objects.equals(aSponsorPhoneno, that.aSponsorPhoneno) && Objects.equals(centralizedDeptId, that.centralizedDeptId) && Objects.equals(centralizedDeptName, that.centralizedDeptName) && Objects.equals(contractIntroduce, that.contractIntroduce) && Objects.equals(fileEcm0301, that.fileEcm0301) && Objects.equals(fileName0301, that.fileName0301) && Objects.equals(fileEcm0305, that.fileEcm0305) && Objects.equals(fileName0305, that.fileName0305) && Objects.equals(fileEcm0306, that.fileEcm0306) && Objects.equals(fileName0306, that.fileName0306) && Objects.equals(fileEcm0304, that.fileEcm0304) && Objects.equals(fileName0304, that.fileName0304) && Objects.equals(fileEcm0314, that.fileEcm0314) && Objects.equals(fileName0314, that.fileName0314) && Objects.equals(recCreateTime, that.recCreateTime) && Objects.equals(recUpdTime, that.recUpdTime) && Objects.equals(originContractNo, that.originContractNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, contractName, contractNo, contractStatus, projectId, projectName, projectNo, projectType, isTripartite, bName, bInsIdCd, bLinkman, bLinkmanName, bLinkmanPhoneno, contractSum, contractSumExcludingTax, contractSourceType, isItContract, assetinfoType, sponsorDeptId, sponsorDeptName, sponsorDeptCode, aSponsorEmp, aSponsorName, aSponsorPhoneno, centralizedDeptId, centralizedDeptName, contractIntroduce, fileEcm0301, fileName0301, fileEcm0305, fileName0305, fileEcm0306, fileName0306, fileEcm0304, fileName0304, fileEcm0314, fileName0314, recCreateTime, recUpdTime, originContractNo);
    }
}