package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmIpmpSupplierBankMapper;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.TEspSupplierBankMapper;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.task.api.BcmIpmpSupplierBankSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmIpmpSyncSupplierBankReqBO;
import com.tydic.bcm.personal.task.bo.BcmIpmpSyncSupplierBankRspBO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 类名： BcmIpmpSupplierBankSyncTaskServiceImpl
 * 说明：于(IPMP)供应商银行的同步与比对实现
 *
 * @author： lishiqing
 * 时间： 2023/9/11 15:29
 */
@HTServiceImpl
public class BcmIpmpSupplierBankSyncTaskServiceImpl implements BcmIpmpSupplierBankSyncTaskService {

    /**
     * 同步日志表--Mapper
     */
    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;

    /**
     * 供应商银行账号临时表Mapper
     */
    @Autowired
    private TEspSupplierBankMapper tEspSupplierBankMapper;

    /**
     * 供应商银行账号Mapper
     */
    @Autowired
    private BcmIpmpSupplierBankMapper bcmIpmpSupplierBankMapper;
    @Value("${dealSize:100}")
    private Integer dealSize;

    @Override
    @Async("global-thread-pool")
    public BcmIpmpSyncSupplierBankRspBO syncIpmpSupplierBank(BcmIpmpSyncSupplierBankReqBO reqBO) {
        //数据对比同步
        sync();
        return BcmRuUtil.success(BcmIpmpSyncSupplierBankRspBO.class);
    }

    /**
     * 更新状态
     * @param ids
     */
    private void changeDealResult(List<Long> ids,String dealResult) {
        TEspSupplierBankUpdatePO setPO = new TEspSupplierBankUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        TEspSupplierBankUpdatePO wherePO = new TEspSupplierBankUpdatePO();
        wherePO.setIdList(ids);
        tEspSupplierBankMapper.updateBy(setPO,wherePO);
    }

    private void sync(){
        // 判断有没有数据写入
        TEspSupplierBankQueryPO qryPO = new TEspSupplierBankQueryPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        Page<TEspSupplierBankPO> page = new Page<>(1,dealSize);
        List<TEspSupplierBankPO> prePageList = tEspSupplierBankMapper.getPageList(qryPO,page);
        List<TEspSupplierBankPO> pageList = new ArrayList<>();
        //没有银行id则置为失败
        List<Long> failIdList = new ArrayList<>();
        if (ObjectUtil.isEmpty(prePageList)) {
            return;
        }else {
            for (TEspSupplierBankPO tEspSupplierBankPO : prePageList) {
                if (ObjectUtil.isEmpty(tEspSupplierBankPO.getBankId())){
                    failIdList.add(tEspSupplierBankPO.getId());
                }else {
                    pageList.add(tEspSupplierBankPO);
                }
            }
        }
        // 已经同步过数据，查询以前存在的数据
        List<String> bankIds = pageList.stream().map(a->a.getBankId()).distinct().collect(Collectors.toList());
        // 成功的就是要同步给能力平台的
        List<Long> successIdList = new ArrayList<>();
        // 新增的数据
        List<BcmIpmpSupplierBankPO> insertPOList = new ArrayList<>();
        // 未改变的ID集合
        List<Long> skipIdList = new ArrayList<>();

        BcmIpmpSupplierBankPO qryOldPO = new BcmIpmpSupplierBankPO();
        qryOldPO.setBankIds(bankIds);
        List<BcmIpmpSupplierBankPO> oldBankPOList = bcmIpmpSupplierBankMapper.getList(qryOldPO);
        Map<String, BcmIpmpSupplierBankPO> oldBankMap = oldBankPOList.stream().collect(Collectors.
                toMap(BcmIpmpSupplierBankPO::getBankId, Function.identity(), (e1, e2) -> e2));
        if (ObjectUtil.isEmpty(oldBankPOList)) {
            for (TEspSupplierBankPO newBankPO : pageList ) {
                BcmIpmpSupplierBankPO insertPO = JSON.parseObject(JSON.toJSONString(newBankPO),BcmIpmpSupplierBankPO.class);
                insertPO.setId(BcmIdUtil.nextId());
                insertPOList.add(insertPO);
                successIdList.add(newBankPO.getId());
            }
        }else {
            for (TEspSupplierBankPO newBankPO : pageList ) {
                if (oldBankMap.containsKey(newBankPO.getBankId())){
                    // 得到存在的OldBankPO
                    BcmIpmpSupplierBankPO oldBankPO = oldBankMap.get(newBankPO.getBankId());
                    // 获得新老对象的Hash值
                    int oldHashCode = oldBankPO.hashCode();
                    int newHashCode = newBankPO.hashCode();
                    // hash码相同，对象的值也是相同的，所以没变化
                    if (oldHashCode == newHashCode) {
                        skipIdList.add(newBankPO.getId());
                    } else { // 设置成功
                        BcmIpmpSupplierBankPO setSupBankPO = JSON.parseObject(JSON.toJSONString(newBankPO),BcmIpmpSupplierBankPO.class);
                        BcmIpmpSupplierBankPO whereSupBankPO = new BcmIpmpSupplierBankPO();
                        whereSupBankPO.setId(oldBankPO.getId());
                        bcmIpmpSupplierBankMapper.updateBy(setSupBankPO,whereSupBankPO);
                        successIdList.add(newBankPO.getId());
                    }
                }else {
                    BcmIpmpSupplierBankPO insertPO = JSON.parseObject(JSON.toJSONString(newBankPO),BcmIpmpSupplierBankPO.class);
                    insertPO.setId(BcmIdUtil.nextId());
                    insertPOList.add(insertPO);
                    successIdList.add(newBankPO.getId());
                }

            }
        }
        //判断无需同步的ID集合
        if (ObjectUtil.isNotEmpty(skipIdList)) {
            changeDealResult(skipIdList,BcmPersonalCommonConstant.DealResult.SKIP);
        }
        // 如果成功的数据不未空
        if (ObjectUtil.isNotEmpty(successIdList)) {
            changeDealResult(successIdList,BcmPersonalCommonConstant.DealResult.SUCCESS);
        }
        // 如果失败的数据不未空
        if (ObjectUtil.isNotEmpty(failIdList)) {
            changeDealResult(failIdList,BcmPersonalCommonConstant.DealResult.FAIL);
        }
        // 新增的数据
        if (ObjectUtil.isNotEmpty(insertPOList)) {
            bcmIpmpSupplierBankMapper.insertBatch(insertPOList);
        }
        if (page.getTotalPages() > 1) {
            sync();
        }
    }
}
