package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmUserOrgGuwpMapper;
import com.tydic.bcm.personal.po.BcmUserOrgGuwpPO;
import com.tydic.bcm.personal.po.BcmUserOrgGuwpQueryPO;
import com.tydic.bcm.personal.po.BcmUserOrgGuwpUpdatePO;
import com.tydic.bcm.personal.task.api.BcmPositionSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncPositionReqBO;
import com.tydic.bcm.personal.task.bo.BcmGuwpSyncPositionRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 类名： BcmPositionSyncTaskServiceImpl
 * 说明：用户兼职同步任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/18 12:37
 */
@HTServiceImpl
@Slf4j
public class BcmPositionSyncTaskServiceImpl implements BcmPositionSyncTaskService {

    @Autowired
    private BcmUserOrgGuwpMapper bcmUserOrgGuwpMapper;

    @Value("${DEAL_POSITION_COUNT:100}")
    private Integer dealCount;

    @Value("${SYNC_CUST_PART_ALL_URL:}")
    private String syncCustPartAllUrl;

    @Value("${FINISH_PART_SYNC:}")
    private String finishPartSync;

    private static final Integer delPage = 1;

    @Override
    @Async("position-sync-thread-pool")
    public BcmGuwpSyncPositionRspBO syncPosition(BcmGuwpSyncPositionReqBO reqBO) {
        BcmGuwpSyncPositionRspBO rspBO = new BcmGuwpSyncPositionRspBO();

        // 查询有没有待处理的数据
        BcmUserOrgGuwpQueryPO qryPO = new BcmUserOrgGuwpQueryPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        Page<BcmUserOrgGuwpPO> page = new Page<>(delPage, dealCount);
        List<BcmUserOrgGuwpPO> pageList = bcmUserOrgGuwpMapper.getPageList(qryPO, page);
        if (ObjectUtil.isEmpty(pageList)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        int syncNum = 0;
        while (true) {
            Page<BcmUserOrgGuwpPO> pageNow = new Page<>(delPage, dealCount);
            pageList = bcmUserOrgGuwpMapper.getPageList(qryPO, pageNow);
            if (ObjectUtil.isEmpty(pageList)) {
                // 如果查不出来记录了，调用同步结束标识
                JSONObject reqStr = new JSONObject();
                reqStr.put("batchId", formatDateTime(new Date()));
                log.info("同步结束之后调用能力平台传结束标识入参为：{}", reqStr.toJSONString());
                String rspStr = HttpUtil.post(finishPartSync, reqStr.toJSONString());
                log.info("同步结束之后调用能力平台传结束标识出参为：{}", rspStr);

                rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
                rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
                rspBO.setSyncNum(syncNum);
                return rspBO;
            }

            // 调用能力平台
            doAbilityMethod(pageList, syncCustPartAllUrl);
            syncNum = syncNum + pageList.size();
        }
    }

    /**
     * 调用能力平台
     *
     * @param successPOList
     * @param url
     */
    private void doAbilityMethod(List<BcmUserOrgGuwpPO> successPOList, String url) {
        List<Long> idList = successPOList.stream().map(BcmUserOrgGuwpPO::getId).collect(Collectors.toList());
        JSONObject reqStr = new JSONObject();
        reqStr.put("batchId", formatDateTime(new Date()));
        reqStr.put("syncList", successPOList);
        log.info("用户兼职同步任务调用能力平台入参为：{}", reqStr);
        String rspStr = HttpUtil.post(url, reqStr.toJSONString());
        log.info("用户兼职同步任务调用能力平台出参为：{}", rspStr);
        // 根据能力平台返回判断
        BaseRspBo baseRspBo = BcmRuUtil.jss(rspStr, BaseRspBo.class);
        if (baseRspBo == null) {
            changeDealResult(idList, BcmPersonalCommonConstant.DealResult.FAIL);
        } else if ("0".equals(baseRspBo.getCode())) {
            changeDealResult(idList, BcmPersonalCommonConstant.DealResult.SUCCESS);
        } else {
            changeDealResult(idList, BcmPersonalCommonConstant.DealResult.FAIL);
        }
    }

    /**
     * 更新状态
     *
     * @param ids
     */
    private void changeDealResult(List<Long> ids, String dealResult) {
        BcmUserOrgGuwpUpdatePO setPO = new BcmUserOrgGuwpUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        BcmUserOrgGuwpUpdatePO wherePO = new BcmUserOrgGuwpUpdatePO();
        wherePO.setIdList(ids);
        bcmUserOrgGuwpMapper.updateBy(setPO, wherePO);
    }

    /**
     * 时间格式化
     *
     * @param date
     * @return
     */
    private String formatDateTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(date);
    }
}
