package com.tydic.bcm.personal.utils;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import java.util.Set;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/7/27 11:47
 */

public class ParamValidateUtils {


    private static final Validator validator;

    static {
        validator = Validation.byDefaultProvider().configure()
                .messageInterpolator(new ResourceBundleMessageInterpolator())
                .buildValidatorFactory().getValidator();
    }

    public static void validate(Object param) {
        Set<ConstraintViolation<Object>> constraintViolations = validator.validate(param);
        if (CollectionUtils.isNotEmpty(constraintViolations)) {
            throw new ZTBusinessException(constraintViolations.iterator().next().getMessage());
        }
    }

}
