/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.address.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.address.api.BcmAddRelaAddressGroupService;
import com.tydic.bcm.personal.address.bo.BcmAddRelaAddressGroupReqBO;
import com.tydic.bcm.personal.address.bo.BcmAddRelaAddressGroupRspBO;
import com.tydic.bcm.personal.address.bo.BcmRelaAddressGroupBO;
import com.tydic.bcm.personal.dao.BcmAddressGroupRelaAddressMapper;
import com.tydic.bcm.personal.po.BcmAddressGroupRelaAddressPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.address.api.BcmAddRelaAddressGroupService"})
public class BcmAddRelaAddressGroupServiceImpl
implements BcmAddRelaAddressGroupService {
    @Autowired
    private BcmAddressGroupRelaAddressMapper bcmAddressGroupRelaAddressMapper;

    @PostMapping(value={"addRelaAddressGroup"})
    public BcmAddRelaAddressGroupRspBO addRelaAddressGroup(@RequestBody BcmAddRelaAddressGroupReqBO reqBO) {
        this.judge(reqBO);
        BcmAddRelaAddressGroupRspBO rspBO = new BcmAddRelaAddressGroupRspBO();
        if (reqBO.getOperType() == 1) {
            this.insertRel(reqBO);
        } else if (reqBO.getOperType() == 2) {
            this.updateRelByGroupId(reqBO);
        } else if (reqBO.getOperType() == 3) {
            this.updateRelByAddressId(reqBO);
        } else if (reqBO.getOperType() == 4) {
            this.deleteRel(reqBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void insertRel(BcmAddRelaAddressGroupReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRelInfoList())) {
            return;
        }
        List insertList = JUtil.jsl((List)reqBO.getRelInfoList(), BcmAddressGroupRelaAddressPO.class);
        for (BcmAddressGroupRelaAddressPO each : insertList) {
            each.setId(BcmIdUtil.nextId());
            each.setCreateUserId(reqBO.getCreateUserId());
            each.setCreateUserName(reqBO.getCreateUserName());
            each.setCreateTime(reqBO.getCreateTime());
        }
        this.bcmAddressGroupRelaAddressMapper.insertBatch(insertList);
    }

    private void updateRelByGroupId(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getGroupId())) {
            throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u4fee\u6539\u65f6\u5165\u53c2\u3010groupId\u3011\u4e3a\u7a7a");
        }
        BcmAddressGroupRelaAddressPO deletePO = new BcmAddressGroupRelaAddressPO();
        deletePO.setGroupId(reqBO.getGroupId());
        this.bcmAddressGroupRelaAddressMapper.deleteBy(deletePO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getRelInfoList())) {
            List addressIds = reqBO.getRelInfoList().stream().map(BcmRelaAddressGroupBO::getAddressId).collect(Collectors.toList());
            ArrayList<BcmAddressGroupRelaAddressPO> insertList = new ArrayList<BcmAddressGroupRelaAddressPO>();
            for (Long addressId : addressIds) {
                BcmAddressGroupRelaAddressPO insertPO = new BcmAddressGroupRelaAddressPO();
                BeanUtils.copyProperties((Object)reqBO, (Object)insertPO);
                insertPO.setId(BcmIdUtil.nextId());
                insertPO.setGroupId(reqBO.getGroupId());
                insertPO.setAddressId(addressId);
                insertList.add(insertPO);
            }
            this.bcmAddressGroupRelaAddressMapper.insertBatch(insertList);
        }
    }

    private void updateRelByAddressId(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getAddressId())) {
            throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u4fee\u6539\u65f6\u5165\u53c2\u3010addressId\u3011\u4e3a\u7a7a");
        }
        BcmAddressGroupRelaAddressPO deletePO = new BcmAddressGroupRelaAddressPO();
        deletePO.setAddressId(reqBO.getAddressId());
        this.bcmAddressGroupRelaAddressMapper.deleteBy(deletePO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getRelInfoList())) {
            List groupIds = reqBO.getRelInfoList().stream().map(BcmRelaAddressGroupBO::getGroupId).collect(Collectors.toList());
            ArrayList<BcmAddressGroupRelaAddressPO> insertList = new ArrayList<BcmAddressGroupRelaAddressPO>();
            for (Long groupId : groupIds) {
                BcmAddressGroupRelaAddressPO insertPO = new BcmAddressGroupRelaAddressPO();
                BeanUtils.copyProperties((Object)reqBO, (Object)insertPO);
                insertPO.setId(BcmIdUtil.nextId());
                insertPO.setGroupId(groupId);
                insertPO.setAddressId(reqBO.getAddressId());
                insertList.add(insertPO);
            }
            this.bcmAddressGroupRelaAddressMapper.insertBatch(insertList);
        }
    }

    private void deleteRel(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getGroupId()) && ObjectUtil.isEmpty((Object)reqBO.getAddressId())) {
            return;
        }
        BcmAddressGroupRelaAddressPO deletePO = new BcmAddressGroupRelaAddressPO();
        deletePO.setGroupId(reqBO.getGroupId());
        deletePO.setAddressId(reqBO.getAddressId());
        this.bcmAddressGroupRelaAddressMapper.deleteBy(deletePO);
    }

    private void judge(BcmAddRelaAddressGroupReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u5904\u7406\u65f6\u5165\u53c2\u3010operType\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateUserId())) {
            throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u5904\u7406\u65f6\u5165\u53c2\u3010createUserId\u3011\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateUserName())) {
            throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u5904\u7406\u65f6\u5165\u53c2\u3010createUserName\u3011\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() == 1) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getRelInfoList())) {
                throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u65b0\u589e\u65f6\u5165\u53c2\u3010relInfoList\u3011\u4e3a\u7a7a");
            }
            for (BcmRelaAddressGroupBO each : reqBO.getRelInfoList()) {
                if (ObjectUtil.isEmpty((Object)each.getGroupId())) {
                    throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u65b0\u589e\u65f6\u5165\u53c2\u3010relInfoList.groupId\u3011\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)each.getAddressId())) continue;
                throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u65b0\u589e\u65f6\u5165\u53c2\u3010relInfoList.addressId\u3011\u4e3a\u7a7a");
            }
        } else if (reqBO.getOperType() == 2) {
            if (ObjectUtil.isEmpty((Object)reqBO.getGroupId())) {
                throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u4fee\u6539\u65f6\u5165\u53c2\u3010groupId\u3011\u4e3a\u7a7a");
            }
        } else if (reqBO.getOperType() == 3) {
            if (ObjectUtil.isEmpty((Object)reqBO.getAddressId())) {
                throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u4fee\u6539\u65f6\u5165\u53c2\u3010addressId\u3011\u4e3a\u7a7a");
            }
        } else if (reqBO.getOperType() == 4) {
            if (ObjectUtil.isEmpty((Object)reqBO.getGroupId()) && ObjectUtil.isEmpty((Object)reqBO.getAddressId())) {
                throw new ZTBusinessException("\u5730\u5740\u5173\u7cfb\u5220\u9664\u65f6\u5165\u53c2\u3010groupId\u3011\u548c\u3010addressId\u3011\u540c\u65f6\u4e3a\u7a7a");
            }
        } else {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getCreateTime())) {
            reqBO.setCreateTime(new Date(System.currentTimeMillis()));
        }
    }
}

