/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmUpdateReplyItemsService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateReplyItemsReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateReplyItemsRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmUpdateReplyItemsService"})
public class BcmUpdateReplyItemsServiceImpl
implements BcmUpdateReplyItemsService {
    private static final Logger log = LoggerFactory.getLogger(BcmUpdateReplyItemsServiceImpl.class);
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @PostMapping(value={"updateReplyItems"})
    public BcmUpdateReplyItemsRspBO updateReplyItems(@RequestBody BcmUpdateReplyItemsReqBO reqBO) {
        log.debug("\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1");
        BcmApplyCommodityOrderPO commodityOrderPO = this.bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (null == commodityOrderPO || ObjectUtils.isEmpty((Object)commodityOrderPO.getId())) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4e0a\u67b6\u7533\u8bf7\u5355\u6570\u636e");
        }
        BcmQueryApplyCommodityOrderSupplierReplyItemPO qryItems = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        qryItems.setApplyOrderId(commodityOrderPO.getApplyOrderId());
        List<BcmApplyCommodityOrderSupplierReplyItemPO> replyItemMapperList = this.bcmApplyCommodityOrderSupplierReplyItemMapper.getList(qryItems);
        if (!CollectionUtils.isEmpty(replyItemMapperList)) {
            this.updateItem(reqBO, replyItemMapperList);
        }
        BcmUpdateReplyItemsRspBO rspBO = new BcmUpdateReplyItemsRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateItem(BcmUpdateReplyItemsReqBO reqBO, List<BcmApplyCommodityOrderSupplierReplyItemPO> replyItemMapperList) {
        BcmApplyCommodityOrderSupplierReplyItemPO miniPrice = replyItemMapperList.stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getSalePrice())).min(Comparator.comparing(BcmApplyCommodityOrderSupplierReplyItemPO::getSalePrice)).orElse(null);
        log.info("\u6700\u4f4e\u4ef7\u4e3a{}", (Object)miniPrice);
        if (null != miniPrice) {
            BcmApplyCommodityOrderSupplierReplyItemPO updateItemPo = new BcmApplyCommodityOrderSupplierReplyItemPO();
            updateItemPo.setId(miniPrice.getId());
            updateItemPo.setReplyItemId(updateItemPo.getReplyItemId());
            updateItemPo.setReplyId(updateItemPo.getReplyItemId());
            updateItemPo.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
            updateItemPo.setUpdateTime(new Date());
            updateItemPo.setUpdateUserId(reqBO.getUpdateUserId());
            updateItemPo.setUpdateUserName(reqBO.getUpdateUserName());
            this.bcmApplyCommodityOrderSupplierReplyItemMapper.update(updateItemPo);
        }
    }

    private void updateOrder(BcmUpdateReplyItemsReqBO reqBO, BcmApplyCommodityOrderPO commodityOrderPO) {
        BcmApplyCommodityOrderPO updatePo = new BcmApplyCommodityOrderPO();
        updatePo.setId(commodityOrderPO.getId());
        updatePo.setApplyOrderId(commodityOrderPO.getApplyOrderId());
        updatePo.setUpdateTime(new Date());
        updatePo.setUpdateUserId(reqBO.getUpdateUserId());
        updatePo.setUpdateUserName(reqBO.getUpdateUserName());
        updatePo.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.IN_SELECT.getStatus());
        this.bcmApplyCommodityOrderMapper.update(updatePo);
    }
}

