/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmVerifyIsMinPriceService;
import com.tydic.bcm.personal.commodity.bo.BcmVerifyIsMinPriceReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmVerifyIsMinPriceRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmVerifyIsMinPriceService"})
public class BcmVerifyIsMinPriceServiceImpl
implements BcmVerifyIsMinPriceService {
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;
    @Autowired
    private BcmApplyCommodityOrderItemMapper bcmApplyCommodityOrderItemMapper;

    @PostMapping(value={"verifyIsMinPrice"})
    public BcmVerifyIsMinPriceRspBO verifyIsMinPrice(@RequestBody BcmVerifyIsMinPriceReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmVerifyIsMinPriceRspBO rspBO = new BcmVerifyIsMinPriceRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setIsMinPrice(Boolean.valueOf(true));
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItemPO = this.bcmApplyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrderItemPO == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u4e0a\u67b6\u7533\u8bf7\u5355\u8be6\u60c5\u4e3a\u7a7a");
        }
        BcmQueryApplyCommodityOrderSupplierReplyItemPO qryItemPo = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        qryItemPo.setApplyOrderId(reqBO.getApplyOrderId());
        List<BcmApplyCommodityOrderSupplierReplyItemPO> itemMapperList = this.bcmApplyCommodityOrderSupplierReplyItemMapper.getList(qryItemPo);
        BcmApplyCommodityOrderSupplierReplyItemPO miniPrice = null;
        if (!CollectionUtils.isEmpty(itemMapperList)) {
            miniPrice = itemMapperList.stream().filter(e -> !ObjectUtils.isEmpty((Object)e.getSalePrice())).min(Comparator.comparing(BcmApplyCommodityOrderSupplierReplyItemPO::getSalePrice)).orElse(null);
        }
        if (null != miniPrice && !ObjectUtils.isEmpty((Object)miniPrice.getSalePrice())) {
            rspBO.setMinPrice(BigDecimal.valueOf(miniPrice.getSalePrice()));
        } else {
            rspBO.setMinPrice(bcmApplyCommodityOrderItemPO.getStartShootPrice());
        }
        if (!ObjectUtils.isEmpty((Object)rspBO.getMinPrice()) && rspBO.getMinPrice().compareTo(reqBO.getSalePrice()) <= 0) {
            rspBO.setIsMinPrice(Boolean.valueOf(false));
            return rspBO;
        }
        return rspBO;
    }

    private void verifyParam(BcmVerifyIsMinPriceReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getApplyOrderId() == null) {
            throw new ZTBusinessException("\u53c2\u6570applyOrderId\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSalePrice() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u5355\u4ef7salePrice\u4e0d\u80fd\u4e3anull");
        }
    }
}

