/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmBranchBankRelevanceInvoiceService;
import com.tydic.bcm.personal.common.bo.BcmBranchBankRelevanceInvoiceReqBO;
import com.tydic.bcm.personal.common.bo.BcmBranchBankRelevanceInvoiceRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBranchBankInvoiceRelaMapper;
import com.tydic.bcm.personal.dao.BcmBranchBankMapper;
import com.tydic.bcm.personal.po.BcmBranchBankInvoiceRelaPO;
import com.tydic.bcm.personal.po.BcmBranchBankInvoiceRelaQueryPO;
import com.tydic.bcm.personal.po.BcmBranchBankPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmBranchBankRelevanceInvoiceService"})
public class BcmBranchBankRelevanceInvoiceServiceImpl
implements BcmBranchBankRelevanceInvoiceService {
    @Autowired
    private BcmBranchBankInvoiceRelaMapper branchBankInvoiceRelaMapper;
    @Autowired
    private BcmBranchBankMapper branchBankMapper;

    @PostMapping(value={"relevanceInvoice"})
    public BcmBranchBankRelevanceInvoiceRspBO relevanceInvoice(@RequestBody BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        this.verifyParam(reqBO);
        this.checkBranchBank(reqBO);
        if (BcmPersonalCommonConstant.OperType.ADD.equals(reqBO.getOperaType())) {
            this.addBranchBankInvoice(reqBO);
        } else if (BcmPersonalCommonConstant.OperType.UPDATE.equals(reqBO.getOperaType())) {
            this.deleteBranchBankInvoice(reqBO);
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        this.updateBranchBank(reqBO);
        return BcmRuUtil.success(BcmBranchBankRelevanceInvoiceRspBO.class);
    }

    private void deleteBranchBankInvoice(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        BcmBranchBankInvoiceRelaQueryPO bcmBranchBankInvoiceRelaQueryPO = new BcmBranchBankInvoiceRelaQueryPO();
        bcmBranchBankInvoiceRelaQueryPO.setInvoiceIdList(reqBO.getInvoiceIdList());
        bcmBranchBankInvoiceRelaQueryPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        this.branchBankInvoiceRelaMapper.delete(bcmBranchBankInvoiceRelaQueryPO);
    }

    private void checkBranchBank(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        BcmBranchBankPO bcmBranchBankPO = new BcmBranchBankPO();
        bcmBranchBankPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        BcmBranchBankPO model = this.branchBankMapper.getModel(bcmBranchBankPO);
        if (model == null) {
            throw new ZTBusinessException("\u4e0d\u5b58\u5728\u6b64\u5206\u884c");
        }
    }

    private void updateBranchBank(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        BcmBranchBankPO bcmBranchBankPO = new BcmBranchBankPO();
        bcmBranchBankPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
        bcmBranchBankPO.setUpdateTime(new Date());
        this.branchBankMapper.update(bcmBranchBankPO);
    }

    private void addBranchBankInvoice(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        ArrayList<BcmBranchBankInvoiceRelaPO> bcmBranchBankInvoiceRelaPOS = new ArrayList<BcmBranchBankInvoiceRelaPO>(reqBO.getInvoiceIdList().size());
        for (Long invoiceId : reqBO.getInvoiceIdList()) {
            BcmBranchBankInvoiceRelaPO bcmBranchBankInvoiceRelaPO = new BcmBranchBankInvoiceRelaPO();
            bcmBranchBankInvoiceRelaPO.setId(BcmIdUtil.nextId());
            bcmBranchBankInvoiceRelaPO.setBranchBankOrgId(reqBO.getBranchBankOrgId());
            bcmBranchBankInvoiceRelaPO.setInvoiceId(invoiceId);
            bcmBranchBankInvoiceRelaPOS.add(bcmBranchBankInvoiceRelaPO);
        }
        this.branchBankInvoiceRelaMapper.insertBach(bcmBranchBankInvoiceRelaPOS);
    }

    private void verifyParam(BcmBranchBankRelevanceInvoiceReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isBlank((String)reqBO.getBranchBankOrgId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5206\u884c\u673a\u6784id\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceIdList())) {
            throw new ZTBusinessException("\u5165\u53c2\u53d1\u7968id\u96c6\u5408\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getOperaType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        }
    }
}

