/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncBudgetProjectService;
import com.tydic.bcm.personal.common.bo.BcmBudgetProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBudgetProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBudgetProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmFullSyncBudgetProjectService"})
public class BcmFullSyncBudgetProjectServiceImpl
implements BcmFullSyncBudgetProjectService {
    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    @PostMapping(value={"fullSyncBudgetProject"})
    public BcmFullSyncBudgetProjectRspBO fullSyncBudgetProject(@RequestBody BcmFullSyncBudgetProjectReqBO reqBO) {
        this.verifyParam(reqBO);
        this.fullSync(reqBO);
        return BcmRuUtil.success(BcmFullSyncBudgetProjectRspBO.class);
    }

    private void fullSync(BcmFullSyncBudgetProjectReqBO reqBO) {
        List<BcmBudgetProjectInfoPO> bcmBudgetProjectInfoPOS = BcmRuUtil.jsl(reqBO.getBudgetProjectList(), BcmBudgetProjectInfoPO.class);
        Date now = new Date();
        for (BcmBudgetProjectInfoPO po : bcmBudgetProjectInfoPOS) {
            if (po.getCreateTime() == null) {
                po.setCreateTime(now);
            }
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        }
        this.bcmBudgetProjectInfoMapper.insertBatch(bcmBudgetProjectInfoPOS);
    }

    private void verifyParam(BcmFullSyncBudgetProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBudgetProjectList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmBudgetProjectInfoBO bo : reqBO.getBudgetProjectList()) {
            if (StringUtils.isEmpty((Object)bo.getProjectCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProjectName())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

