/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncPaymentProjectService;
import com.tydic.bcm.personal.common.bo.BcmFullSyncPaymentProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncPaymentProjectRspBO;
import com.tydic.bcm.personal.common.bo.BcmPaymentProjectInfoBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmFullSyncPaymentProjectService"})
public class BcmFullSyncPaymentProjectServiceImpl
implements BcmFullSyncPaymentProjectService {
    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    @PostMapping(value={"fullSyncPaymentProject"})
    public BcmFullSyncPaymentProjectRspBO fullSyncPaymentProject(@RequestBody BcmFullSyncPaymentProjectReqBO reqBO) {
        this.verifyParam(reqBO);
        this.fullSync(reqBO);
        return BcmRuUtil.success(BcmFullSyncPaymentProjectRspBO.class);
    }

    private void fullSync(BcmFullSyncPaymentProjectReqBO reqBO) {
        List<BcmPaymentProjectInfoPO> bcmPaymentProjectInfoPOS = BcmRuUtil.jsl(reqBO.getPaymentProjectList(), BcmPaymentProjectInfoPO.class);
        Date now = new Date();
        for (BcmPaymentProjectInfoPO po : bcmPaymentProjectInfoPOS) {
            if (po.getCreateTime() == null) {
                po.setCreateTime(now);
            }
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        }
        this.bcmPaymentProjectInfoMapper.insertBatch(bcmPaymentProjectInfoPOS);
    }

    private void verifyParam(BcmFullSyncPaymentProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPaymentProjectList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmPaymentProjectInfoBO bo : reqBO.getPaymentProjectList()) {
            if (StringUtils.isEmpty((Object)bo.getProjectCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProjectName())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getFinancialOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u8d22\u52a1\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

