/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.flow.impl;

import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.flow.api.BcmCancelFlowService;
import com.tydic.bcm.personal.flow.bo.BcmCancelFlowReqBO;
import com.tydic.bcm.personal.flow.bo.BcmCancelFlowRspBO;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.flow.api.BcmCancelFlowService"})
public class BcmCancelFlowServiceImpl
implements BcmCancelFlowService {
    @Autowired
    private BcmFlowInstanceMapper bcmFlowInstanceMapper;
    @Autowired
    private BcmFlowTaskMapper bcmFlowTaskMapper;

    @PostMapping(value={"cancelFlow"})
    public BcmCancelFlowRspBO cancelFlow(@RequestBody BcmCancelFlowReqBO reqBO) {
        this.verifyParam(reqBO);
        this.updateFlowInstance(reqBO);
        this.updateFlowTask(reqBO);
        return BcmRuUtil.success(BcmCancelFlowRspBO.class);
    }

    private void updateFlowInstance(BcmCancelFlowReqBO reqBO) {
        BcmFlowInstancePO bcmFlowInstancePO = new BcmFlowInstancePO();
        bcmFlowInstancePO.setFlowInstId(reqBO.getFlowInstId());
        bcmFlowInstancePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
        this.bcmFlowInstanceMapper.update(bcmFlowInstancePO);
    }

    private void updateFlowTask(BcmCancelFlowReqBO reqBO) {
        BcmFlowTaskPO bcmFlowTaskPO = new BcmFlowTaskPO();
        bcmFlowTaskPO.setFlowInstId(reqBO.getFlowInstId());
        bcmFlowTaskPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);
        this.bcmFlowTaskMapper.update(bcmFlowTaskPO);
    }

    private void verifyParam(BcmCancelFlowReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (StrUtil.isBlank((CharSequence)reqBO.getFlowInstId())) {
            throw new ZTBusinessException("\u5165\u53c2\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3anull");
        }
    }
}

